package com.els.base.certification.contrast.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;

public class CompanyContrastPrintUtils {
	private static final Logger log = LoggerFactory.getLogger(CompanyContrastPrintUtils.class);
	
	public static FileData generatePdf(String projectId, String companyId, Map<String, Object> params, String printType) throws Exception{
		log.debug("【对比表打印】生成pdf文件");
		
		String filename = null;  //pdf文件名
        FileData pdfFile = null; //pdf文件
        String html = null;      //pdf生成需要的html
        
        switch (printType) {
	        case "A4":
	            //1 根据模板生成html
	            html = BeetlTemplateUtils.renderFromFile("companyContrast.html", params);
	
	            //2 生成文件名
	            filename =  "潜在供应商对比表_A4_" + DateFormatUtils.format(new Date(), "yyyy-MM-dd-HH-mm");
	            //3 生成空的pdf文件
	            pdfFile = createEmptyPDF(projectId, companyId, filename);
	            //4根据html 生成pdf，并写入pdf文件里面
	            HtmlToPdfUtils.generatePdf(html, pdfFile.toFile(), HtmlToPdfUtils.PAGE_SIZE_A4, true, filename);
	            break;
	        default:
	            throw new CommonException("不支持当前打印类型["+printType+"]");
        }
        return pdfFile;
	}	
	
	private static FileData createEmptyPDF(String projectId, String companyId, String filename)
            throws  IOException{
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);

        pdfFile.setFileName(filename+".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays(new Date(), 2));
        pdfFile = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")) , pdfFile);
        return pdfFile;
    }
}
