package com.els.base.certification.contrast.web.controller;

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value="潜在供应商对比表行项")
@Controller
@RequestMapping("companyContrastItem")
public class CompanyContrastItemController {
    @Resource
    private CompanyContrastItemService companyContrastItemService;

//    @ApiOperation(httpMethod="POST", value="创建T_BASE_COMPANY_CONTRAST_ITEM")
//    @RequestMapping("service/create")
//    @ResponseBody
//    public ResponseResult<String> create(@RequestBody CompanyContrastItem companyContrastItem) {
//        this.companyContrastItemService.addObj(companyContrastItem);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="编辑T_BASE_COMPANY_CONTRAST_ITEM")
//    @RequestMapping("service/edit")
//    @ResponseBody
//    public ResponseResult<String> edit(@RequestBody CompanyContrastItem companyContrastItem) {
//        if (StringUtils.isBlank(companyContrastItem.getId())) {
//            throw new CommonException("id 为空，保存失败");
//        }
//        this.companyContrastItemService.modifyObj(companyContrastItem);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="删除T_BASE_COMPANY_CONTRAST_ITEM")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
//        if (StringUtils.isBlank(id)) {
//            throw new CommonException("删除失败,id不能为空");
//        }
//        this.companyContrastItemService.deleteObjById(id);
//        return ResponseResult.success();
//    }

//    @ApiOperation(httpMethod="POST", value="查询T_BASE_COMPANY_CONTRAST_ITEM")
//    @ApiImplicitParams({ 
//	 @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
//	 @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
//	 @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyContrastItem", paramType = "body", dataType = "QueryParamWapper" )  
//}) 
//    @RequestMapping("service/findByPage")
//    @ResponseBody
//    public ResponseResult<PageView<CompanyContrastItem>> findByPage( 
//	 @RequestParam(defaultValue="0") int pageNo,  
//	 @RequestParam(defaultValue="10") int pageSize, 
//	 @RequestBody(required=false) QueryParamWapper wapper) {
//        CompanyContrastItemExample example = new CompanyContrastItemExample();
//        example.setPageView(new PageView<CompanyContrastItem>(pageNo, pageSize));
//        
//        if (wapper != null) {
//            CompanyContrastItemExample.Criteria criteria = example.createCriteria();
//            CriteriaUtils.addCriterion(criteria, wapper);
//        }
//        
//        PageView<CompanyContrastItem> pageData = this.companyContrastItemService.queryObjByPage(example);
//        return ResponseResult.success(pageData);
//    }
    
    @ApiOperation(httpMethod="POST", value="查询潜在供应商导入表明细")
    @RequestMapping("service/findCompanyContrastDetails")
    @ResponseBody
    public ResponseResult<List<CompanyContrastItem>> findCompanyContrastDetails( 
    		 @RequestBody(required=false) QueryParamWapper wapper) {
    	CompanyContrastItemExample example = new CompanyContrastItemExample();
    	CompanyContrastItemExample.Criteria criteria = example.createCriteria();
    	
    	if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
    	
    	List<CompanyContrastItem> list = this.companyContrastItemService.queryAllObjByExample(example);
    	return ResponseResult.success(list);
    }
}