package com.els.base.certification.customer.service.impl;

import com.els.base.certification.customer.dao.CompanyCustomerMapper;
import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCompanyCustomerService")
public class CompanyCustomerServiceImpl implements CompanyCustomerService {
    @Resource
    protected CompanyCustomerMapper companyCustomerMapper;

    @Cacheable(value="companyCustomer", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyCustomerExample companyCustomerExample =new CompanyCustomerExample();
        //如果数据为空，那么返回0
        companyCustomerExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if(this.companyCustomerMapper.countByExample(companyCustomerExample)<=0){
            return 0;
        }
        
        //如果数据不为空，那么判断完成状态只要有0，那么返回未完成
        companyCustomerExample.clear();
        companyCustomerExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);
        int count = this.companyCustomerMapper.countByExample(companyCustomerExample);
        if(count>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    @Override
    public void addObj(CompanyCustomer t) {
        this.companyCustomerMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyCustomerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    @Override
    public void modifyObj(CompanyCustomer t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyCustomerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyCustomer", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyCustomer queryObjById(String id) {
        return this.companyCustomerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyCustomer", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyCustomer> queryAllObjByExample(CompanyCustomerExample example) {
        return this.companyCustomerMapper.selectByExample(example);
    }

    @Cacheable(value="companyCustomer", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyCustomer> queryObjByPage(CompanyCustomerExample example) {
        PageView<CompanyCustomer> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCustomerMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyCustomer"}, allEntries=true)
	@Override
	public Integer batchInsert(String projectId, Company supCompany, Company purCompany,
                               List<CompanyCustomer> customerList) {
		if(CollectionUtils.isEmpty(customerList)){
			throw new CommonException("操作失败，数据不能为空!");
		}
		
		CompanyCustomerExample example = new CompanyCustomerExample();
		example.createCriteria()
			   .andProjectIdEqualTo(projectId)
		       .andSupCompanyIdEqualTo(supCompany.getId())
		       .andIsEnableEqualTo(Constant.YES_INT);
		
		CompanyCustomer customer = new CompanyCustomer();
		customer.setIsEnable(Constant.NO_INT);
		
		this.companyCustomerMapper.updateByExampleSelective(customer, example);

        List<Integer> list = new ArrayList<Integer>();

		for (CompanyCustomer companyCustomer : customerList) {
			companyCustomer.setId(null);
			companyCustomer.setProjectId(projectId);
			companyCustomer.setPurCompanyId(purCompany.getId());
			companyCustomer.setPurCompanySrmCode(purCompany.getCompanyCode());
			companyCustomer.setPurCompanyName(purCompany.getCompanyName());
			companyCustomer.setSupCompanyId(supCompany.getId());
			companyCustomer.setSupCompanySrmCode(supCompany.getCompanyCode());
			companyCustomer.setSupCompanyName(supCompany.getCompanyName());
			companyCustomer.setIsEnable(Constant.YES_INT);
			companyCustomer.setCreateTime(new Date());
			companyCustomer.setUpdateTime(new Date());
			companyCustomer.setFinishFlag(Constant.NO_INT);
			//完成标识,一开始默认是0,0也是非空,不会影响非空判断
			Integer finishFlag = companyCustomer.getFinishFlag();
			companyCustomer.setFinishFlag(finishFlag);
			this.addObj(companyCustomer);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }
    
    @Transactional
    @CacheEvict(value={"companyCustomer"}, allEntries=true)
	@Override
	public void deleteObjByIds(String projectId, Company company, List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
        	throw new CommonException("传递的id列表为空!");
        }
    	CompanyCustomerExample example = new CompanyCustomerExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
		   .andSupCompanyIdEqualTo(company.getId())
		   .andIdIn(ids);
    	
    	CompanyCustomer customer = new CompanyCustomer();
    	customer.setIsEnable(Constant.NO_INT);
    	
    	this.companyCustomerMapper.updateByExampleSelective(customer, example);
	}
}