package com.els.base.certification.device.service;

import java.util.List;

import com.els.base.certification.device.entity.CompanyProductDevice;
import com.els.base.certification.device.entity.CompanyProductDeviceExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface CompanyProductDeviceService extends BaseService<CompanyProductDevice, CompanyProductDeviceExample, String> {
	/**
	 * 批量插入数据
     * @param projectId
     * @param supCompany
     * @param purCompany
     * @param productDeviceList
     */
	Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyProductDevice> productDeviceList);

	/**
	 * 删除数据
	 * @param projectId
	 * @param company
	 * @param ids
	 */
	void deleteObjByIds(String projectId, Company company, List<String> ids);

	/**
	 * 测试是否填完
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
}