package com.els.base.certification.device.service.impl;

import com.els.base.certification.device.dao.CompanyProductDeviceMapper;
import com.els.base.certification.device.entity.CompanyProductDevice;
import com.els.base.certification.device.entity.CompanyProductDeviceExample;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCompanyProductDeviceService")
public class CompanyProductDeviceServiceImpl implements CompanyProductDeviceService {
    @Resource
    protected CompanyProductDeviceMapper companyProductDeviceMapper;

    @Cacheable(value="companyProductDevice", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyProductDeviceExample companyProductDeviceExample =new CompanyProductDeviceExample();
        //如果数据为空，那么返回0
        companyProductDeviceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyProductDeviceMapper.countByExample(companyProductDeviceExample);
        if(count<=0){
            return 0;
        }

        companyProductDeviceExample.clear();
        companyProductDeviceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyProductDeviceMapper.countByExample(companyProductDeviceExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyProductDevice"}, allEntries=true)
    @Override
    public void addObj(CompanyProductDevice t) {
        this.companyProductDeviceMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyProductDevice"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyProductDeviceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyProductDevice"}, allEntries=true)
    @Override
    public void modifyObj(CompanyProductDevice t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyProductDeviceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyProductDevice", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyProductDevice queryObjById(String id) {
        return this.companyProductDeviceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyProductDevice", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyProductDevice> queryAllObjByExample(CompanyProductDeviceExample example) {
        return this.companyProductDeviceMapper.selectByExample(example);
    }

    @Cacheable(value="companyProductDevice", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyProductDevice> queryObjByPage(CompanyProductDeviceExample example) {
        PageView<CompanyProductDevice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyProductDeviceMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyProductDevice"}, allEntries=true)
	@Override
	public Integer batchInsert(String projectId, Company supCompany, Company purCompany,
                               List<CompanyProductDevice> productDeviceList) {
    	if(CollectionUtils.isEmpty(productDeviceList)){
			throw new CommonException("操作失败，数据不能为空!");
		}
    	
    	CompanyProductDeviceExample example = new CompanyProductDeviceExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
	       .andSupCompanyIdEqualTo(supCompany.getId())
	       .andIsEnableEqualTo(Constant.YES_INT);
    	
    	CompanyProductDevice device = new CompanyProductDevice();
    	device.setIsEnable(Constant.NO_INT);
    	
    	this.companyProductDeviceMapper.updateByExampleSelective(device, example);


        List<Integer> list = new ArrayList<>();

        for (CompanyProductDevice companyProductDevice : productDeviceList) {
    		companyProductDevice.setId(null);
			companyProductDevice.setProjectId(projectId);
			companyProductDevice.setPurCompanyId(purCompany.getId());
			companyProductDevice.setPurCompanySrmCode(purCompany.getCompanyCode());
			companyProductDevice.setPurCompanyName(purCompany.getCompanyName());
			companyProductDevice.setSupCompanyId(supCompany.getId());
			companyProductDevice.setSupCompanySrmCode(supCompany.getCompanyCode());
			companyProductDevice.setSupCompanyName(supCompany.getCompanyName());
			companyProductDevice.setIsEnable(Constant.YES_INT);
			companyProductDevice.setCreateTime(new Date());
			companyProductDevice.setUpdateTime(new Date());
			companyProductDevice.setFinishFlag(Constant.NO_INT);

            Integer finishFlag = companyProductDevice.getFinishFlag();
            companyProductDevice.setFinishFlag(finishFlag);
			this.addObj(companyProductDevice);

            list.add(finishFlag);

		}
        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }
    }
	
    @Transactional
	@CacheEvict(value={"companyProductDevice"}, allEntries=true)
	@Override
	public void deleteObjByIds(String projectId, Company company, List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
        	throw new CommonException("传递的id列表为空!");
        }
    	
    	CompanyProductDeviceExample example = new CompanyProductDeviceExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
		   .andSupCompanyIdEqualTo(company.getId())
		   .andIdIn(ids);
    	
    	CompanyProductDevice device = new CompanyProductDevice();
    	device.setIsEnable(Constant.NO_INT);
    	
    	this.companyProductDeviceMapper.updateByExampleSelective(device, example);
    }
}