package com.els.base.certification.equipment.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="关键试验，检验设备")
public class CompanyEquipment  extends AbstractCompany implements Serializable {
	//非自动生成
    //忽略校验的字段
    @Override
    protected List<String> exculdeFieldNames() {
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("projectId");
        filedNameList.add("supCompanyId");
        filedNameList.add("equipmentCode");
        filedNameList.add("createTime");
        filedNameList.add("remark");
        filedNameList.add("finishFlag");
        filedNameList.add("isEnable");
        filedNameList.add("updateTime");
        return filedNameList;
    }
	
	@ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("设备型号")
    private String equipmentCode;

    @ApiModelProperty("设备名称")
    private String equipmentName;

    @ApiModelProperty("设备生产地")
    private String equipmentProductPlace;

    @ApiModelProperty("技术指标，优势简述")
    private String equipmentAdvantage;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("设备数量")
    private Integer equipmentQuantity;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("设备生产时间")
    private Date equipmentCreateTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("设备生产商")
    private String equipmentProducter;

    @ApiModelProperty("同级设备购买计划")
    private String purchasePlan;
    
    @ApiModelProperty("测量精度")
    private String measureAccuracy;

    @ApiModelProperty("检测范围(量程)")
    private String detectionRange;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode == null ? null : equipmentCode.trim();
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName == null ? null : equipmentName.trim();
    }

    public String getEquipmentProductPlace() {
        return equipmentProductPlace;
    }

    public void setEquipmentProductPlace(String equipmentProductPlace) {
        this.equipmentProductPlace = equipmentProductPlace == null ? null : equipmentProductPlace.trim();
    }

    public String getEquipmentAdvantage() {
        return equipmentAdvantage;
    }

    public void setEquipmentAdvantage(String equipmentAdvantage) {
        this.equipmentAdvantage = equipmentAdvantage == null ? null : equipmentAdvantage.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getEquipmentQuantity() {
        return equipmentQuantity;
    }

    public void setEquipmentQuantity(Integer equipmentQuantity) {
        this.equipmentQuantity = equipmentQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

  /*  public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getEquipmentCreateTime() {
        return equipmentCreateTime;
    }

    public void setEquipmentCreateTime(Date equipmentCreateTime) {
        this.equipmentCreateTime = equipmentCreateTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getEquipmentProducter() {
        return equipmentProducter;
    }

    public void setEquipmentProducter(String equipmentProducter) {
        this.equipmentProducter = equipmentProducter == null ? null : equipmentProducter.trim();
    }

    public String getPurchasePlan() {
        return purchasePlan;
    }

    public void setPurchasePlan(String purchasePlan) {
        this.purchasePlan = purchasePlan == null ? null : purchasePlan.trim();
    }
    
    public String getMeasureAccuracy() {
        return measureAccuracy;
    }

    public void setMeasureAccuracy(String measureAccuracy) {
        this.measureAccuracy = measureAccuracy == null ? null : measureAccuracy.trim();
    }

    public String getDetectionRange() {
        return detectionRange;
    }

    public void setDetectionRange(String detectionRange) {
        this.detectionRange = detectionRange == null ? null : detectionRange.trim();
    }
}