package com.els.base.certification.equipment.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompanyEquipmentExample extends AbstractExample<CompanyEquipment> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<CompanyEquipment> pageView = new PageView<CompanyEquipment>(1, 10);

    private static final long serialVersionUID = 1L;

    public CompanyEquipmentExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<CompanyEquipment> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<CompanyEquipment> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeIsNull() {
            addCriterion("EQUIPMENT_CODE is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeIsNotNull() {
            addCriterion("EQUIPMENT_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeEqualTo(String value) {
            addCriterion("EQUIPMENT_CODE =", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeNotEqualTo(String value) {
            addCriterion("EQUIPMENT_CODE <>", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeGreaterThan(String value) {
            addCriterion("EQUIPMENT_CODE >", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeGreaterThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_CODE >=", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeLessThan(String value) {
            addCriterion("EQUIPMENT_CODE <", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeLessThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_CODE <=", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeLike(String value) {
            addCriterion("EQUIPMENT_CODE like", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeNotLike(String value) {
            addCriterion("EQUIPMENT_CODE not like", value, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeIn(List<String> values) {
            addCriterion("EQUIPMENT_CODE in", values, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeNotIn(List<String> values) {
            addCriterion("EQUIPMENT_CODE not in", values, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_CODE between", value1, value2, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentCodeNotBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_CODE not between", value1, value2, "equipmentCode");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameIsNull() {
            addCriterion("EQUIPMENT_NAME is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameIsNotNull() {
            addCriterion("EQUIPMENT_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameEqualTo(String value) {
            addCriterion("EQUIPMENT_NAME =", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameNotEqualTo(String value) {
            addCriterion("EQUIPMENT_NAME <>", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameGreaterThan(String value) {
            addCriterion("EQUIPMENT_NAME >", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameGreaterThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_NAME >=", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameLessThan(String value) {
            addCriterion("EQUIPMENT_NAME <", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameLessThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_NAME <=", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameLike(String value) {
            addCriterion("EQUIPMENT_NAME like", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameNotLike(String value) {
            addCriterion("EQUIPMENT_NAME not like", value, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameIn(List<String> values) {
            addCriterion("EQUIPMENT_NAME in", values, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameNotIn(List<String> values) {
            addCriterion("EQUIPMENT_NAME not in", values, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_NAME between", value1, value2, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentNameNotBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_NAME not between", value1, value2, "equipmentName");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceIsNull() {
            addCriterion("EQUIPMENT_PRODUCT_PLACE is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceIsNotNull() {
            addCriterion("EQUIPMENT_PRODUCT_PLACE is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE =", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceNotEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE <>", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceGreaterThan(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE >", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceGreaterThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE >=", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceLessThan(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE <", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceLessThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE <=", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceLike(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE like", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceNotLike(String value) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE not like", value, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceIn(List<String> values) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE in", values, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceNotIn(List<String> values) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE not in", values, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE between", value1, value2, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentProductPlaceNotBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_PRODUCT_PLACE not between", value1, value2, "equipmentProductPlace");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageIsNull() {
            addCriterion("EQUIPMENT_ADVANTAGE is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageIsNotNull() {
            addCriterion("EQUIPMENT_ADVANTAGE is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageEqualTo(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE =", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageNotEqualTo(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE <>", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageGreaterThan(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE >", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageGreaterThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE >=", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageLessThan(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE <", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageLessThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE <=", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageLike(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE like", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageNotLike(String value) {
            addCriterion("EQUIPMENT_ADVANTAGE not like", value, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageIn(List<String> values) {
            addCriterion("EQUIPMENT_ADVANTAGE in", values, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageNotIn(List<String> values) {
            addCriterion("EQUIPMENT_ADVANTAGE not in", values, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_ADVANTAGE between", value1, value2, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andEquipmentAdvantageNotBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_ADVANTAGE not between", value1, value2, "equipmentAdvantage");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityIsNull() {
            addCriterion("EQUIPMENT_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityIsNotNull() {
            addCriterion("EQUIPMENT_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityEqualTo(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY =", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityNotEqualTo(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY <>", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityGreaterThan(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY >", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityGreaterThanOrEqualTo(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY >=", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityLessThan(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY <", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityLessThanOrEqualTo(Integer value) {
            addCriterion("EQUIPMENT_QUANTITY <=", value, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityIn(List<Integer> values) {
            addCriterion("EQUIPMENT_QUANTITY in", values, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityNotIn(List<Integer> values) {
            addCriterion("EQUIPMENT_QUANTITY not in", values, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityBetween(Integer value1, Integer value2) {
            addCriterion("EQUIPMENT_QUANTITY between", value1, value2, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andEquipmentQuantityNotBetween(Integer value1, Integer value2) {
            addCriterion("EQUIPMENT_QUANTITY not between", value1, value2, "equipmentQuantity");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNull() {
            addCriterion("REMARK is null");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNotNull() {
            addCriterion("REMARK is not null");
            return (Criteria) this;
        }

        public Criteria andRemarkEqualTo(String value) {
            addCriterion("REMARK =", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotEqualTo(String value) {
            addCriterion("REMARK <>", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThan(String value) {
            addCriterion("REMARK >", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("REMARK >=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThan(String value) {
            addCriterion("REMARK <", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThanOrEqualTo(String value) {
            addCriterion("REMARK <=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLike(String value) {
            addCriterion("REMARK like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotLike(String value) {
            addCriterion("REMARK not like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkIn(List<String> values) {
            addCriterion("REMARK in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotIn(List<String> values) {
            addCriterion("REMARK not in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkBetween(String value1, String value2) {
            addCriterion("REMARK between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotBetween(String value1, String value2) {
            addCriterion("REMARK not between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNull() {
            addCriterion("FINISH_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNotNull() {
            addCriterion("FINISH_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagEqualTo(Integer value) {
            addCriterion("FINISH_FLAG =", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <>", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThan(Integer value) {
            addCriterion("FINISH_FLAG >", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG >=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThan(Integer value) {
            addCriterion("FINISH_FLAG <", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIn(List<Integer> values) {
            addCriterion("FINISH_FLAG in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotIn(List<Integer> values) {
            addCriterion("FINISH_FLAG not in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG not between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeIsNull() {
            addCriterion("EQUIPMENT_CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeIsNotNull() {
            addCriterion("EQUIPMENT_CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeEqualTo(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME =", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeNotEqualTo(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME <>", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeGreaterThan(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME >", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME >=", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeLessThan(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME <", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("EQUIPMENT_CREATE_TIME <=", value, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeIn(List<Date> values) {
            addCriterion("EQUIPMENT_CREATE_TIME in", values, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeNotIn(List<Date> values) {
            addCriterion("EQUIPMENT_CREATE_TIME not in", values, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeBetween(Date value1, Date value2) {
            addCriterion("EQUIPMENT_CREATE_TIME between", value1, value2, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("EQUIPMENT_CREATE_TIME not between", value1, value2, "equipmentCreateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterIsNull() {
            addCriterion("EQUIPMENT_PRODUCTER is null");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterIsNotNull() {
            addCriterion("EQUIPMENT_PRODUCTER is not null");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCTER =", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterNotEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCTER <>", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterGreaterThan(String value) {
            addCriterion("EQUIPMENT_PRODUCTER >", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterGreaterThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCTER >=", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterLessThan(String value) {
            addCriterion("EQUIPMENT_PRODUCTER <", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterLessThanOrEqualTo(String value) {
            addCriterion("EQUIPMENT_PRODUCTER <=", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterLike(String value) {
            addCriterion("EQUIPMENT_PRODUCTER like", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterNotLike(String value) {
            addCriterion("EQUIPMENT_PRODUCTER not like", value, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterIn(List<String> values) {
            addCriterion("EQUIPMENT_PRODUCTER in", values, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterNotIn(List<String> values) {
            addCriterion("EQUIPMENT_PRODUCTER not in", values, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_PRODUCTER between", value1, value2, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andEquipmentProducterNotBetween(String value1, String value2) {
            addCriterion("EQUIPMENT_PRODUCTER not between", value1, value2, "equipmentProducter");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanIsNull() {
            addCriterion("PURCHASE_PLAN is null");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanIsNotNull() {
            addCriterion("PURCHASE_PLAN is not null");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanEqualTo(String value) {
            addCriterion("PURCHASE_PLAN =", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanNotEqualTo(String value) {
            addCriterion("PURCHASE_PLAN <>", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanGreaterThan(String value) {
            addCriterion("PURCHASE_PLAN >", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_PLAN >=", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanLessThan(String value) {
            addCriterion("PURCHASE_PLAN <", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_PLAN <=", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanLike(String value) {
            addCriterion("PURCHASE_PLAN like", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanNotLike(String value) {
            addCriterion("PURCHASE_PLAN not like", value, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanIn(List<String> values) {
            addCriterion("PURCHASE_PLAN in", values, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanNotIn(List<String> values) {
            addCriterion("PURCHASE_PLAN not in", values, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanBetween(String value1, String value2) {
            addCriterion("PURCHASE_PLAN between", value1, value2, "purchasePlan");
            return (Criteria) this;
        }

        public Criteria andPurchasePlanNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_PLAN not between", value1, value2, "purchasePlan");
            return (Criteria) this;
        }
        
        public Criteria andMeasureAccuracyIsNull() {
            addCriterion("MEASURE_ACCURACY is null");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyIsNotNull() {
            addCriterion("MEASURE_ACCURACY is not null");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyEqualTo(String value) {
            addCriterion("MEASURE_ACCURACY =", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyNotEqualTo(String value) {
            addCriterion("MEASURE_ACCURACY <>", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyGreaterThan(String value) {
            addCriterion("MEASURE_ACCURACY >", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyGreaterThanOrEqualTo(String value) {
            addCriterion("MEASURE_ACCURACY >=", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyLessThan(String value) {
            addCriterion("MEASURE_ACCURACY <", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyLessThanOrEqualTo(String value) {
            addCriterion("MEASURE_ACCURACY <=", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyLike(String value) {
            addCriterion("MEASURE_ACCURACY like", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyNotLike(String value) {
            addCriterion("MEASURE_ACCURACY not like", value, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyIn(List<String> values) {
            addCriterion("MEASURE_ACCURACY in", values, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyNotIn(List<String> values) {
            addCriterion("MEASURE_ACCURACY not in", values, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyBetween(String value1, String value2) {
            addCriterion("MEASURE_ACCURACY between", value1, value2, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andMeasureAccuracyNotBetween(String value1, String value2) {
            addCriterion("MEASURE_ACCURACY not between", value1, value2, "measureAccuracy");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeIsNull() {
            addCriterion("DETECTION_RANGE is null");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeIsNotNull() {
            addCriterion("DETECTION_RANGE is not null");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeEqualTo(String value) {
            addCriterion("DETECTION_RANGE =", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeNotEqualTo(String value) {
            addCriterion("DETECTION_RANGE <>", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeGreaterThan(String value) {
            addCriterion("DETECTION_RANGE >", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeGreaterThanOrEqualTo(String value) {
            addCriterion("DETECTION_RANGE >=", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeLessThan(String value) {
            addCriterion("DETECTION_RANGE <", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeLessThanOrEqualTo(String value) {
            addCriterion("DETECTION_RANGE <=", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeLike(String value) {
            addCriterion("DETECTION_RANGE like", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeNotLike(String value) {
            addCriterion("DETECTION_RANGE not like", value, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeIn(List<String> values) {
            addCriterion("DETECTION_RANGE in", values, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeNotIn(List<String> values) {
            addCriterion("DETECTION_RANGE not in", values, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeBetween(String value1, String value2) {
            addCriterion("DETECTION_RANGE between", value1, value2, "detectionRange");
            return (Criteria) this;
        }

        public Criteria andDetectionRangeNotBetween(String value1, String value2) {
            addCriterion("DETECTION_RANGE not between", value1, value2, "detectionRange");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}