package com.els.base.certification.equipment.service;

import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyEquipmentService extends BaseService<CompanyEquipment, CompanyEquipmentExample, String> {

    /**
     * 批量添加设备信息
     * @param projectId
     * @param company
     * @param companyEquipmentList
     */
    Integer batchInsert(String projectId, Company company, List<CompanyEquipment> companyEquipmentList);

    /**
     * 批量软删除设备信息
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 判断是否已经填完资料
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}