package com.els.base.certification.equipment.service.impl;

import com.els.base.certification.equipment.dao.CompanyEquipmentMapper;
import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyEquipmentService")
public class CompanyEquipmentServiceImpl implements CompanyEquipmentService {

    @Resource
    private CompanyEquipmentMapper companyEquipmentMapper;

    @Cacheable(value="companyEquipment", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyEquipmentExample companyEquipmentExample =new CompanyEquipmentExample();
        //如果数据为空，那么返回0
        companyEquipmentExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyEquipmentMapper.countByExample(companyEquipmentExample);
        if(count<=0){
            return 0;
        }

        companyEquipmentExample.clear();
        companyEquipmentExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyEquipmentMapper.countByExample(companyEquipmentExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyEquipment companyEquipment =new CompanyEquipment();
        companyEquipment.setIsEnable(Constant.NO_INT);

        CompanyEquipmentExample companyEquipmentExample=new CompanyEquipmentExample();
        companyEquipmentExample.createCriteria()
                .andSupCompanyIdEqualTo(company.getId())
                .andIdIn(ids);

        this.companyEquipmentMapper.updateByExampleSelective(companyEquipment,companyEquipmentExample);
    }

    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Transactional
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanyEquipment> companyEquipmentList) {

        if (CollectionUtils.isEmpty(companyEquipmentList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        //先删除该供应商下全部的设备信息
        CompanyEquipmentExample companyEquipmentExample =new CompanyEquipmentExample();
        companyEquipmentExample
                .createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        CompanyEquipment equipment=new CompanyEquipment();
        equipment.setIsEnable(Constant.NO_INT);
        companyEquipmentMapper.updateByExampleSelective(equipment,companyEquipmentExample);

        List<Integer> list = new ArrayList<Integer>();
        for (CompanyEquipment companyEquipment : companyEquipmentList) {
            companyEquipment.setId(null);
            companyEquipment.setProjectId(projectId);
            companyEquipment.setSupCompanyId(company.getId());
            companyEquipment.setIsEnable(Constant.YES_INT);
            companyEquipment.setCreateTime(new Date());
            companyEquipment.setUpdateTime(new Date());

            //特殊处理
            companyEquipment.setEquipmentCode("无");
            companyEquipment.setRemark("无");

            Integer finishFlag = companyEquipment.getFinishFlag();
            companyEquipment.setFinishFlag(finishFlag);
            companyEquipmentMapper.insertSelective(companyEquipment);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Override
    public void addObj(CompanyEquipment t) {
        this.companyEquipmentMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyEquipmentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Override
    public void modifyObj(CompanyEquipment t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyEquipmentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyEquipment", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyEquipment queryObjById(String id) {
        return this.companyEquipmentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyEquipment", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyEquipment> queryAllObjByExample(CompanyEquipmentExample example) {
        return this.companyEquipmentMapper.selectByExample(example);
    }

    @Cacheable(value="companyEquipment", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyEquipment> queryObjByPage(CompanyEquipmentExample example) {
        PageView<CompanyEquipment> pageView = example.getPageView();
        pageView.setQueryResult(this.companyEquipmentMapper.selectByExampleByPage(example));
        return pageView;
    }
}