package com.els.base.certification.exempt.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商豁免单")
public class Exempt implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("单据状态(1为已保存,2为正在审核,3为已审核,4为已驳回)")
    private String status;

    @ApiModelProperty("供应商编码")
    private String supCompanySrmCode;

    @ApiModelProperty("单据号")
    private String documentNumber;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("供应商类型(1为标准件，2为定制件)")
    private String supplierType;

    @ApiModelProperty("产品特性描述")
    private String productCharacterization;

    @ApiModelProperty("需求来源")
    private String demandSources;

    @ApiModelProperty("引入原因")
    private String introduceReason;

    @ApiModelProperty("需求分析")
    private String requirementAnalysis;

    @ApiModelProperty("目前状况")
    private String currentStatus;

    @ApiModelProperty("必要性分析")
    private String necessityAnalysis;

    @ApiModelProperty("结论")
    private String conclusion;

    @ApiModelProperty("供应商英文名称")
    private String supCompanyEnglishName;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("综合评价及风险点")
    private String overviewAndRisk;

    @ApiModelProperty("豁免理由")
    private String exemptionReason;

    @ApiModelProperty("制单人")
    private String singlePerson;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("当前待审批人")
    private String pendingApprovalPeople;

    @ApiModelProperty("审核时间")
    private Date auditTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("单据是否作废(0=不作废，1=作废)")
    private Integer isInvalid;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber == null ? null : documentNumber.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupplierType() {
        return supplierType;
    }

    public void setSupplierType(String supplierType) {
        this.supplierType = supplierType == null ? null : supplierType.trim();
    }

    public String getProductCharacterization() {
        return productCharacterization;
    }

    public void setProductCharacterization(String productCharacterization) {
        this.productCharacterization = productCharacterization == null ? null : productCharacterization.trim();
    }

    public String getDemandSources() {
        return demandSources;
    }

    public void setDemandSources(String demandSources) {
        this.demandSources = demandSources == null ? null : demandSources.trim();
    }

    public String getIntroduceReason() {
        return introduceReason;
    }

    public void setIntroduceReason(String introduceReason) {
        this.introduceReason = introduceReason == null ? null : introduceReason.trim();
    }

    public String getRequirementAnalysis() {
        return requirementAnalysis;
    }

    public void setRequirementAnalysis(String requirementAnalysis) {
        this.requirementAnalysis = requirementAnalysis == null ? null : requirementAnalysis.trim();
    }

    public String getCurrentStatus() {
        return currentStatus;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus == null ? null : currentStatus.trim();
    }

    public String getNecessityAnalysis() {
        return necessityAnalysis;
    }

    public void setNecessityAnalysis(String necessityAnalysis) {
        this.necessityAnalysis = necessityAnalysis == null ? null : necessityAnalysis.trim();
    }

    public String getConclusion() {
        return conclusion;
    }

    public void setConclusion(String conclusion) {
        this.conclusion = conclusion == null ? null : conclusion.trim();
    }

    public String getSupCompanyEnglishName() {
        return supCompanyEnglishName;
    }

    public void setSupCompanyEnglishName(String supCompanyEnglishName) {
        this.supCompanyEnglishName = supCompanyEnglishName == null ? null : supCompanyEnglishName.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public String getOverviewAndRisk() {
        return overviewAndRisk;
    }

    public void setOverviewAndRisk(String overviewAndRisk) {
        this.overviewAndRisk = overviewAndRisk == null ? null : overviewAndRisk.trim();
    }

    public String getExemptionReason() {
        return exemptionReason;
    }

    public void setExemptionReason(String exemptionReason) {
        this.exemptionReason = exemptionReason == null ? null : exemptionReason.trim();
    }

    public String getSinglePerson() {
        return singlePerson;
    }

    public void setSinglePerson(String singlePerson) {
        this.singlePerson = singlePerson == null ? null : singlePerson.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPendingApprovalPeople() {
        return pendingApprovalPeople;
    }

    public void setPendingApprovalPeople(String pendingApprovalPeople) {
        this.pendingApprovalPeople = pendingApprovalPeople == null ? null : pendingApprovalPeople.trim();
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsInvalid() {
        return isInvalid;
    }

    public void setIsInvalid(Integer isInvalid) {
        this.isInvalid = isInvalid;
    }
}