package com.els.base.certification.exempt.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.certification.exempt.entity.Exempt;
import com.els.base.certification.exempt.entity.ExemptExample;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;

public interface ExemptService extends BaseService<Exempt, ExemptExample, String> {
	/**
	 * 是否作废单据
	 * @param exempt
	 */
	public void updateIsInvalid(List<Exempt> exempt);
	
	/**
	 * 更新单据状态为已审核
	 * @param exempt
	 */
	public void updateStatus(String id);
	
	/**
	 * 批量删除单据
	 * @param supExempt
	 */
	public void deleteObjByIds(List<Exempt> supExempt);
	
	/**
	 * 更改单据状态为已发送审批
	 */
	public void sendToApprove(List<String> supIds);
	
	/**
	 * 创建供应商豁免单
	 * @param user
	 * @param exempt
	 */
	public void insert(User user, Exempt exempt);
	
	/**
	 * 供应商豁免单打印
	 * @param projectId
	 * @param currentCompanyId
	 * @param data
	 * @return
	 */
	public FileData print(String projectId, String currentCompanyId, List<Exempt> data);
}