package com.els.base.certification.exempt.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.exempt.entity.Exempt;
import com.els.base.certification.exempt.entity.ExemptExample;
import com.els.base.certification.exempt.service.ExemptService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "供应商豁免单")
@Controller
@RequestMapping("exempt")
public class ExemptController {
	@Resource
	protected ExemptService exemptService;
	@Resource
	protected CompanyService companyService;

	@ApiOperation(httpMethod = "POST", value = "创建供应商豁免单")
	@RequestMapping("service/create")
	@ResponseBody
	public ResponseResult<String> create(@RequestBody Exempt exempt) {
		if (StringUtils.isBlank(exempt.getSupCompanySrmCode())) {
			throw new CommonException("供应商编码为空，保存失败");
		}
		User user = SpringSecurityUtils.getLoginUser();
		this.exemptService.insert(user,exempt);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "编辑供应商豁免单")
	@RequestMapping("service/edit")
	@ResponseBody
	public ResponseResult<String> edit(@RequestBody Exempt exempt) {
		if (StringUtils.isBlank(exempt.getId())) {
			throw new CommonException("id 为空，保存失败");
		}
		Assert.isNotBlank(exempt.getSupCompanySrmCode(), "供应商编码不能为空");
		this.exemptService.modifyObj(exempt);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "删除供应商豁免单")
	@RequestMapping("service/deleteByIds")
	@ResponseBody
	public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<Exempt> supExempt) {
		if(CollectionUtils.isEmpty(supExempt)){
			throw new CommonException("操作失败,数据不能为空");
		}
		this.exemptService.deleteObjByIds(supExempt);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "作废供应商豁免单")
	@RequestMapping("service/invalidExemption")
	@ResponseBody
	public ResponseResult<String> invalidExemption(@RequestBody(required = true) List<Exempt> supExempt) {
		if(CollectionUtils.isEmpty(supExempt)){
			throw new CommonException("操作失败，数据不能为空");
		}
		this.exemptService.updateIsInvalid(supExempt);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "查询供应商豁免单")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"), @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"), @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Exempt", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<Exempt>> findByPage(@RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
		ExemptExample example = new ExemptExample();
		example.setPageView(new PageView<Exempt>(pageNo, pageSize));
		example.setOrderByClause("CREATE_TIME DESC");
		ExemptExample.Criteria criteria = example.createCriteria();

		if (wapper != null) {
			CriteriaUtils.addCriterion(criteria, wapper);
		}

		PageView<Exempt> pageData = this.exemptService.queryObjByPage(example);
		return ResponseResult.success(pageData);
	}
	
	@ApiOperation(httpMethod="POST", value="根据ID查看供应商豁免单单据详情")
	@RequestMapping("service/findDetailById")
	@ResponseBody
	public ResponseResult<Exempt> findDetailById(@RequestParam(required=true) String id){
		Assert.isNotBlank(id, "单据ID不能为空");
		Exempt exempt=this.exemptService.queryObjById(id);
		return ResponseResult.success(exempt);
	}
	
	@ApiOperation(httpMethod = "POST", value = "根据供应商编码查询供应商信息")
	@RequestMapping("service/selectCompany")
	@ResponseBody
	public ResponseResult<Company> selectCompany(@RequestParam(required = true) String companyCode){
		Company company=this.companyService.queryCompanyByCode(companyCode);
		return ResponseResult.success(company);
	}
	
	@ApiOperation(httpMethod = "POST", value = "发送审批")
	@RequestMapping("service/sendApproval")
	@ResponseBody
	public ResponseResult<String> sendApproal(@RequestBody List<String> ids){
		if(CollectionUtils.isEmpty(ids)){
			throw new CommonException("发送失败，数据不能为空");
		}
		this.exemptService.sendToApprove(ids);
		return ResponseResult.success();
	} 
	
	@ApiOperation(httpMethod="POST",value="供应商豁免单打印")
	@RequestMapping("service/print")
	@ResponseBody
	public ResponseResult<FileData> print(@RequestBody(required=true) List<Exempt> data){
		FileData fileData=this.exemptService.print(ProjectUtils.getProjectId(),CompanyUtils.currentCompanyId(),data);
		return ResponseResult.success(fileData);
	}
}