package com.els.base.certification.finance.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="财务信息")
public class CompanyFinance  extends AbstractCompany implements Serializable {

    //非自动生成

    //忽略校验的字段
    @Override
    protected List<String> exculdeFieldNames() {
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("remark");
        filedNameList.add("startTime");
        filedNameList.add("entTime");
        filedNameList.add("assetTypeCode");
        filedNameList.add("projectId");
        filedNameList.add("supCompanyId");
        filedNameList.add("isEnable");
        filedNameList.add("createTime");
        filedNameList.add("updateTime");
        filedNameList.add("finishFlag");
        return filedNameList;
    }
    //非自动生成

    @ApiModelProperty("ID主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("资产类型")
    private Integer assetTypeCode;

    @ApiModelProperty("资产类型名称")
    private String assetTypeName;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date entTime;

    @ApiModelProperty("营业额")
    private String businessVolume;

    @ApiModelProperty("销售成本")
    private String sellingCost;

    @ApiModelProperty("总资产")
    private String totalAssets;

    @ApiModelProperty("总负债")
    private String grossLiabilities;

    @ApiModelProperty("应收账款")
    private String accountReceivable;

    @ApiModelProperty("应付账款")
    private String accountPayable;

    @ApiModelProperty("同类产品毛利率")
    private String grossProfitRate;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public Integer getAssetTypeCode() {
        return assetTypeCode;
    }

    public void setAssetTypeCode(Integer assetTypeCode) {
        this.assetTypeCode = assetTypeCode;
    }

    public String getAssetTypeName() {
        return assetTypeName;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName == null ? null : assetTypeName.trim();
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEntTime() {
        return entTime;
    }

    public void setEntTime(Date entTime) {
        this.entTime = entTime;
    }

    public String getBusinessVolume() {
        return businessVolume;
    }

    public void setBusinessVolume(String businessVolume) {
        this.businessVolume = businessVolume == null ? null : businessVolume.trim();
    }

    public String getSellingCost() {
        return sellingCost;
    }

    public void setSellingCost(String sellingCost) {
        this.sellingCost = sellingCost == null ? null : sellingCost.trim();
    }

    public String getTotalAssets() {
        return totalAssets;
    }

    public void setTotalAssets(String totalAssets) {
        this.totalAssets = totalAssets == null ? null : totalAssets.trim();
    }

    public String getGrossLiabilities() {
        return grossLiabilities;
    }

    public void setGrossLiabilities(String grossLiabilities) {
        this.grossLiabilities = grossLiabilities == null ? null : grossLiabilities.trim();
    }

    public String getAccountReceivable() {
        return accountReceivable;
    }

    public void setAccountReceivable(String accountReceivable) {
        this.accountReceivable = accountReceivable == null ? null : accountReceivable.trim();
    }

    public String getAccountPayable() {
        return accountPayable;
    }

    public void setAccountPayable(String accountPayable) {
        this.accountPayable = accountPayable == null ? null : accountPayable.trim();
    }

    public String getGrossProfitRate() {
        return grossProfitRate;
    }

    public void setGrossProfitRate(String grossProfitRate) {
        this.grossProfitRate = grossProfitRate == null ? null : grossProfitRate.trim();
    }

  /*  public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}