package com.els.base.certification.finance.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompanyFinanceExample extends AbstractExample<CompanyFinance> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<CompanyFinance> pageView = new PageView<CompanyFinance>(1, 10);

    private static final long serialVersionUID = 1L;

    public CompanyFinanceExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<CompanyFinance> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<CompanyFinance> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeIsNull() {
            addCriterion("ASSET_TYPE_CODE is null");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeIsNotNull() {
            addCriterion("ASSET_TYPE_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeEqualTo(Integer value) {
            addCriterion("ASSET_TYPE_CODE =", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeNotEqualTo(Integer value) {
            addCriterion("ASSET_TYPE_CODE <>", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeGreaterThan(Integer value) {
            addCriterion("ASSET_TYPE_CODE >", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeGreaterThanOrEqualTo(Integer value) {
            addCriterion("ASSET_TYPE_CODE >=", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeLessThan(Integer value) {
            addCriterion("ASSET_TYPE_CODE <", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeLessThanOrEqualTo(Integer value) {
            addCriterion("ASSET_TYPE_CODE <=", value, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeIn(List<Integer> values) {
            addCriterion("ASSET_TYPE_CODE in", values, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeNotIn(List<Integer> values) {
            addCriterion("ASSET_TYPE_CODE not in", values, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeBetween(Integer value1, Integer value2) {
            addCriterion("ASSET_TYPE_CODE between", value1, value2, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeCodeNotBetween(Integer value1, Integer value2) {
            addCriterion("ASSET_TYPE_CODE not between", value1, value2, "assetTypeCode");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameIsNull() {
            addCriterion("ASSET_TYPE_NAME is null");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameIsNotNull() {
            addCriterion("ASSET_TYPE_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameEqualTo(String value) {
            addCriterion("ASSET_TYPE_NAME =", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameNotEqualTo(String value) {
            addCriterion("ASSET_TYPE_NAME <>", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameGreaterThan(String value) {
            addCriterion("ASSET_TYPE_NAME >", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameGreaterThanOrEqualTo(String value) {
            addCriterion("ASSET_TYPE_NAME >=", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameLessThan(String value) {
            addCriterion("ASSET_TYPE_NAME <", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameLessThanOrEqualTo(String value) {
            addCriterion("ASSET_TYPE_NAME <=", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameLike(String value) {
            addCriterion("ASSET_TYPE_NAME like", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameNotLike(String value) {
            addCriterion("ASSET_TYPE_NAME not like", value, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameIn(List<String> values) {
            addCriterion("ASSET_TYPE_NAME in", values, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameNotIn(List<String> values) {
            addCriterion("ASSET_TYPE_NAME not in", values, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameBetween(String value1, String value2) {
            addCriterion("ASSET_TYPE_NAME between", value1, value2, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andAssetTypeNameNotBetween(String value1, String value2) {
            addCriterion("ASSET_TYPE_NAME not between", value1, value2, "assetTypeName");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNull() {
            addCriterion("START_TIME is null");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNotNull() {
            addCriterion("START_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andStartTimeEqualTo(Date value) {
            addCriterion("START_TIME =", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotEqualTo(Date value) {
            addCriterion("START_TIME <>", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThan(Date value) {
            addCriterion("START_TIME >", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("START_TIME >=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThan(Date value) {
            addCriterion("START_TIME <", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThanOrEqualTo(Date value) {
            addCriterion("START_TIME <=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeIn(List<Date> values) {
            addCriterion("START_TIME in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotIn(List<Date> values) {
            addCriterion("START_TIME not in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeBetween(Date value1, Date value2) {
            addCriterion("START_TIME between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotBetween(Date value1, Date value2) {
            addCriterion("START_TIME not between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeIsNull() {
            addCriterion("ENT_TIME is null");
            return (Criteria) this;
        }

        public Criteria andEntTimeIsNotNull() {
            addCriterion("ENT_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andEntTimeEqualTo(Date value) {
            addCriterion("ENT_TIME =", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeNotEqualTo(Date value) {
            addCriterion("ENT_TIME <>", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeGreaterThan(Date value) {
            addCriterion("ENT_TIME >", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("ENT_TIME >=", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeLessThan(Date value) {
            addCriterion("ENT_TIME <", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeLessThanOrEqualTo(Date value) {
            addCriterion("ENT_TIME <=", value, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeIn(List<Date> values) {
            addCriterion("ENT_TIME in", values, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeNotIn(List<Date> values) {
            addCriterion("ENT_TIME not in", values, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeBetween(Date value1, Date value2) {
            addCriterion("ENT_TIME between", value1, value2, "entTime");
            return (Criteria) this;
        }

        public Criteria andEntTimeNotBetween(Date value1, Date value2) {
            addCriterion("ENT_TIME not between", value1, value2, "entTime");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeIsNull() {
            addCriterion("BUSINESS_VOLUME is null");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeIsNotNull() {
            addCriterion("BUSINESS_VOLUME is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeEqualTo(String value) {
            addCriterion("BUSINESS_VOLUME =", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeNotEqualTo(String value) {
            addCriterion("BUSINESS_VOLUME <>", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeGreaterThan(String value) {
            addCriterion("BUSINESS_VOLUME >", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_VOLUME >=", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeLessThan(String value) {
            addCriterion("BUSINESS_VOLUME <", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_VOLUME <=", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeLike(String value) {
            addCriterion("BUSINESS_VOLUME like", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeNotLike(String value) {
            addCriterion("BUSINESS_VOLUME not like", value, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeIn(List<String> values) {
            addCriterion("BUSINESS_VOLUME in", values, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeNotIn(List<String> values) {
            addCriterion("BUSINESS_VOLUME not in", values, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeBetween(String value1, String value2) {
            addCriterion("BUSINESS_VOLUME between", value1, value2, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andBusinessVolumeNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_VOLUME not between", value1, value2, "businessVolume");
            return (Criteria) this;
        }

        public Criteria andSellingCostIsNull() {
            addCriterion("SELLING_COST is null");
            return (Criteria) this;
        }

        public Criteria andSellingCostIsNotNull() {
            addCriterion("SELLING_COST is not null");
            return (Criteria) this;
        }

        public Criteria andSellingCostEqualTo(String value) {
            addCriterion("SELLING_COST =", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostNotEqualTo(String value) {
            addCriterion("SELLING_COST <>", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostGreaterThan(String value) {
            addCriterion("SELLING_COST >", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostGreaterThanOrEqualTo(String value) {
            addCriterion("SELLING_COST >=", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostLessThan(String value) {
            addCriterion("SELLING_COST <", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostLessThanOrEqualTo(String value) {
            addCriterion("SELLING_COST <=", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostLike(String value) {
            addCriterion("SELLING_COST like", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostNotLike(String value) {
            addCriterion("SELLING_COST not like", value, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostIn(List<String> values) {
            addCriterion("SELLING_COST in", values, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostNotIn(List<String> values) {
            addCriterion("SELLING_COST not in", values, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostBetween(String value1, String value2) {
            addCriterion("SELLING_COST between", value1, value2, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andSellingCostNotBetween(String value1, String value2) {
            addCriterion("SELLING_COST not between", value1, value2, "sellingCost");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsIsNull() {
            addCriterion("TOTAL_ASSETS is null");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsIsNotNull() {
            addCriterion("TOTAL_ASSETS is not null");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsEqualTo(String value) {
            addCriterion("TOTAL_ASSETS =", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsNotEqualTo(String value) {
            addCriterion("TOTAL_ASSETS <>", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsGreaterThan(String value) {
            addCriterion("TOTAL_ASSETS >", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsGreaterThanOrEqualTo(String value) {
            addCriterion("TOTAL_ASSETS >=", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsLessThan(String value) {
            addCriterion("TOTAL_ASSETS <", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsLessThanOrEqualTo(String value) {
            addCriterion("TOTAL_ASSETS <=", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsLike(String value) {
            addCriterion("TOTAL_ASSETS like", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsNotLike(String value) {
            addCriterion("TOTAL_ASSETS not like", value, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsIn(List<String> values) {
            addCriterion("TOTAL_ASSETS in", values, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsNotIn(List<String> values) {
            addCriterion("TOTAL_ASSETS not in", values, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsBetween(String value1, String value2) {
            addCriterion("TOTAL_ASSETS between", value1, value2, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andTotalAssetsNotBetween(String value1, String value2) {
            addCriterion("TOTAL_ASSETS not between", value1, value2, "totalAssets");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesIsNull() {
            addCriterion("GROSS_LIABILITIES is null");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesIsNotNull() {
            addCriterion("GROSS_LIABILITIES is not null");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesEqualTo(String value) {
            addCriterion("GROSS_LIABILITIES =", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesNotEqualTo(String value) {
            addCriterion("GROSS_LIABILITIES <>", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesGreaterThan(String value) {
            addCriterion("GROSS_LIABILITIES >", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesGreaterThanOrEqualTo(String value) {
            addCriterion("GROSS_LIABILITIES >=", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesLessThan(String value) {
            addCriterion("GROSS_LIABILITIES <", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesLessThanOrEqualTo(String value) {
            addCriterion("GROSS_LIABILITIES <=", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesLike(String value) {
            addCriterion("GROSS_LIABILITIES like", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesNotLike(String value) {
            addCriterion("GROSS_LIABILITIES not like", value, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesIn(List<String> values) {
            addCriterion("GROSS_LIABILITIES in", values, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesNotIn(List<String> values) {
            addCriterion("GROSS_LIABILITIES not in", values, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesBetween(String value1, String value2) {
            addCriterion("GROSS_LIABILITIES between", value1, value2, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andGrossLiabilitiesNotBetween(String value1, String value2) {
            addCriterion("GROSS_LIABILITIES not between", value1, value2, "grossLiabilities");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableIsNull() {
            addCriterion("ACCOUNT_RECEIVABLE is null");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableIsNotNull() {
            addCriterion("ACCOUNT_RECEIVABLE is not null");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableEqualTo(String value) {
            addCriterion("ACCOUNT_RECEIVABLE =", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableNotEqualTo(String value) {
            addCriterion("ACCOUNT_RECEIVABLE <>", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableGreaterThan(String value) {
            addCriterion("ACCOUNT_RECEIVABLE >", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableGreaterThanOrEqualTo(String value) {
            addCriterion("ACCOUNT_RECEIVABLE >=", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableLessThan(String value) {
            addCriterion("ACCOUNT_RECEIVABLE <", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableLessThanOrEqualTo(String value) {
            addCriterion("ACCOUNT_RECEIVABLE <=", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableLike(String value) {
            addCriterion("ACCOUNT_RECEIVABLE like", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableNotLike(String value) {
            addCriterion("ACCOUNT_RECEIVABLE not like", value, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableIn(List<String> values) {
            addCriterion("ACCOUNT_RECEIVABLE in", values, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableNotIn(List<String> values) {
            addCriterion("ACCOUNT_RECEIVABLE not in", values, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableBetween(String value1, String value2) {
            addCriterion("ACCOUNT_RECEIVABLE between", value1, value2, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountReceivableNotBetween(String value1, String value2) {
            addCriterion("ACCOUNT_RECEIVABLE not between", value1, value2, "accountReceivable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableIsNull() {
            addCriterion("ACCOUNT_PAYABLE is null");
            return (Criteria) this;
        }

        public Criteria andAccountPayableIsNotNull() {
            addCriterion("ACCOUNT_PAYABLE is not null");
            return (Criteria) this;
        }

        public Criteria andAccountPayableEqualTo(String value) {
            addCriterion("ACCOUNT_PAYABLE =", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableNotEqualTo(String value) {
            addCriterion("ACCOUNT_PAYABLE <>", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableGreaterThan(String value) {
            addCriterion("ACCOUNT_PAYABLE >", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableGreaterThanOrEqualTo(String value) {
            addCriterion("ACCOUNT_PAYABLE >=", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableLessThan(String value) {
            addCriterion("ACCOUNT_PAYABLE <", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableLessThanOrEqualTo(String value) {
            addCriterion("ACCOUNT_PAYABLE <=", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableLike(String value) {
            addCriterion("ACCOUNT_PAYABLE like", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableNotLike(String value) {
            addCriterion("ACCOUNT_PAYABLE not like", value, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableIn(List<String> values) {
            addCriterion("ACCOUNT_PAYABLE in", values, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableNotIn(List<String> values) {
            addCriterion("ACCOUNT_PAYABLE not in", values, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableBetween(String value1, String value2) {
            addCriterion("ACCOUNT_PAYABLE between", value1, value2, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andAccountPayableNotBetween(String value1, String value2) {
            addCriterion("ACCOUNT_PAYABLE not between", value1, value2, "accountPayable");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateIsNull() {
            addCriterion("GROSS_PROFIT_RATE is null");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateIsNotNull() {
            addCriterion("GROSS_PROFIT_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateEqualTo(String value) {
            addCriterion("GROSS_PROFIT_RATE =", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateNotEqualTo(String value) {
            addCriterion("GROSS_PROFIT_RATE <>", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateGreaterThan(String value) {
            addCriterion("GROSS_PROFIT_RATE >", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateGreaterThanOrEqualTo(String value) {
            addCriterion("GROSS_PROFIT_RATE >=", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateLessThan(String value) {
            addCriterion("GROSS_PROFIT_RATE <", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateLessThanOrEqualTo(String value) {
            addCriterion("GROSS_PROFIT_RATE <=", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateLike(String value) {
            addCriterion("GROSS_PROFIT_RATE like", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateNotLike(String value) {
            addCriterion("GROSS_PROFIT_RATE not like", value, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateIn(List<String> values) {
            addCriterion("GROSS_PROFIT_RATE in", values, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateNotIn(List<String> values) {
            addCriterion("GROSS_PROFIT_RATE not in", values, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateBetween(String value1, String value2) {
            addCriterion("GROSS_PROFIT_RATE between", value1, value2, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andGrossProfitRateNotBetween(String value1, String value2) {
            addCriterion("GROSS_PROFIT_RATE not between", value1, value2, "grossProfitRate");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNull() {
            addCriterion("FINISH_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNotNull() {
            addCriterion("FINISH_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagEqualTo(Integer value) {
            addCriterion("FINISH_FLAG =", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <>", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThan(Integer value) {
            addCriterion("FINISH_FLAG >", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG >=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThan(Integer value) {
            addCriterion("FINISH_FLAG <", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIn(List<Integer> values) {
            addCriterion("FINISH_FLAG in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotIn(List<Integer> values) {
            addCriterion("FINISH_FLAG not in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG not between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNull() {
            addCriterion("REMARK is null");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNotNull() {
            addCriterion("REMARK is not null");
            return (Criteria) this;
        }

        public Criteria andRemarkEqualTo(String value) {
            addCriterion("REMARK =", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotEqualTo(String value) {
            addCriterion("REMARK <>", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThan(String value) {
            addCriterion("REMARK >", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("REMARK >=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThan(String value) {
            addCriterion("REMARK <", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThanOrEqualTo(String value) {
            addCriterion("REMARK <=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLike(String value) {
            addCriterion("REMARK like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotLike(String value) {
            addCriterion("REMARK not like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkIn(List<String> values) {
            addCriterion("REMARK in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotIn(List<String> values) {
            addCriterion("REMARK not in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkBetween(String value1, String value2) {
            addCriterion("REMARK between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotBetween(String value1, String value2) {
            addCriterion("REMARK not between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}