package com.els.base.certification.finance.service;

import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyFinanceService extends BaseService<CompanyFinance, CompanyFinanceExample, String> {

    /**
     * 批量插入
     * @param projectId
     * @param company
     * @param companyFinanceList
     */
    Integer batchInsert(String projectId, Company company, List<CompanyFinance> companyFinanceList);

    /**
     * 批量软删除方法
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 判断是否已经填完资料
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}