package com.els.base.certification.management.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商准入-准入流程管理")
public class ProcessManagement implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购商用户ID")
    private String purUserId;

    @ApiModelProperty("采购商名称")
    private String purCompanyName;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("流程编号")
    private String processNumber;

    @ApiModelProperty("流程名称")
    private String processName;

    @ApiModelProperty("供应商分类名")
    private String supClassificationName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("准入流程")
    private String accessProcess;

    @ApiModelProperty("资质审核模版名称")
    private String qualificationAuditTemplate;

    @ApiModelProperty("现场考察模版名称")
    private String siteInspectionTemplate;

    @ApiModelProperty("创建人")
    private String singlePerson;

    @ApiModelProperty("资质审核模版ID")
    private String qualificationAuditTemplateId;

    @ApiModelProperty("现场考察模版ID")
    private String siteInspectionTemplateId;

    @ApiModelProperty("是否可用(1为可用，0为不可用)")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;
    
    @ApiModelProperty("供应商分类编码")
    private String supplierLevelCode;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getProcessNumber() {
        return processNumber;
    }

    public void setProcessNumber(String processNumber) {
        this.processNumber = processNumber == null ? null : processNumber.trim();
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName == null ? null : processName.trim();
    }

    public String getSupClassificationName() {
        return supClassificationName;
    }

    public void setSupClassificationName(String supClassificationName) {
        this.supClassificationName = supClassificationName == null ? null : supClassificationName.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAccessProcess() {
        return accessProcess;
    }

    public void setAccessProcess(String accessProcess) {
        this.accessProcess = accessProcess == null ? null : accessProcess.trim();
    }

    public String getQualificationAuditTemplate() {
        return qualificationAuditTemplate;
    }

    public void setQualificationAuditTemplate(String qualificationAuditTemplate) {
        this.qualificationAuditTemplate = qualificationAuditTemplate == null ? null : qualificationAuditTemplate.trim();
    }

    public String getSiteInspectionTemplate() {
        return siteInspectionTemplate;
    }

    public void setSiteInspectionTemplate(String siteInspectionTemplate) {
        this.siteInspectionTemplate = siteInspectionTemplate == null ? null : siteInspectionTemplate.trim();
    }

    public String getSinglePerson() {
        return singlePerson;
    }

    public void setSinglePerson(String singlePerson) {
        this.singlePerson = singlePerson == null ? null : singlePerson.trim();
    }

    public String getQualificationAuditTemplateId() {
        return qualificationAuditTemplateId;
    }

    public void setQualificationAuditTemplateId(String qualificationAuditTemplateId) {
        this.qualificationAuditTemplateId = qualificationAuditTemplateId == null ? null : qualificationAuditTemplateId.trim();
    }

    public String getSiteInspectionTemplateId() {
        return siteInspectionTemplateId;
    }

    public void setSiteInspectionTemplateId(String siteInspectionTemplateId) {
        this.siteInspectionTemplateId = siteInspectionTemplateId == null ? null : siteInspectionTemplateId.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
    
    public String getSupplierLevelCode() {
        return supplierLevelCode;
    }

    public void setSupplierLevelCode(String supplierLevelCode) {
        this.supplierLevelCode = supplierLevelCode == null ? null : supplierLevelCode.trim();
    }
}