package com.els.base.certification.notice.service;

import com.els.base.core.entity.user.User;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyAuditNoticeService extends BaseService<CompanyAuditNotice, CompanyAuditNoticeExample, String> {

    /**
     *  采购商创建现场审核通知单
     * @param projectId
     * @param company
     * @param loginUser
     * @param companyAuditNotice
     */
    void insert(Company purCompany, User loginUser, CompanyAuditNotice companyAuditNotice);

    /**
     * 批量删除现场审核通知单（逻辑删除）
     * @param project
     * @param company
     * @param ids
     */
    void deleteObjByIds(List<String> ids);

    /**
     * 供应商准入--批量发送审核通知单给供应商
     * @param project
     * @param company
     * @param loginUser
     * @param ids
     */
    void send(List<String> ids);

    /**
     *供应商准入-- 批量作废审核通知单
     * @param project
     * @param company
     * @param ids
     */
    void abolish(List<String> ids);

    /**
     * 供应商确认审核通知单
     * @param project
     * @param company
     * @param loginUser
     * @param ids
     */
    void confirm(CompanyAuditNotice data);
}