package com.els.base.certification.notice.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.notice.dao.CompanyAuditNoticeMapper;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.qualification.util.QualificationImTemplet;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyAuditNoticeService")
public class CompanyAuditNoticeServiceImpl implements CompanyAuditNoticeService {
	
	private static final String IM_CODE = "COMPANY_FIELD_INVESTIGATION_NOTICE";

    @Resource
    private CompanyAuditNoticeMapper companyAuditNoticeMapper;
    
    @Resource
    private CompanyService companyService;
    
    @Resource
    private GenerateCodeService generateCodeService;
    
    @Resource
    private  CompanyUserRefService companyUserRefService;
    
    @Resource
    private RoleService roleService;
    
    @Resource
    private UserRoleService userRoleService;
    
    @Resource
    private UserService userService;
    
    @Resource 
    private ProcessService processService;
    
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    @Override
    public void confirm(CompanyAuditNotice data) {

        //校验数据
        if (null == data) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        
        Assert.isNotBlank(data.getSupReplyInformation(), "供应商回复信息不能为空");

        CompanyAuditNoticeExample companyAuditNoticeExample =new CompanyAuditNoticeExample();

        //校验是否包含已经确认的
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdEqualTo(data.getId())
                .andConfirmStatusEqualTo(Constant.YES_INT);

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据是已确认数据，不能再操作!");
        }

        //校验这些数据是否是已经发送的
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdEqualTo(data.getId())
                .andSendStatusEqualTo(Constant.NO_INT);

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据是未发送数据，操作失败!");
        }

        //更新状态
        CompanyAuditNotice companyAuditNotice = this.queryObjById(data.getId());
        if (null == companyAuditNotice) {
        	return;
        }
        companyAuditNotice.setConfirmStatus(Constant.YES_INT);
        companyAuditNotice.setSupReplyInformation(data.getSupReplyInformation());
        this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);

        // 发送消息
        this.defaultThreadPool.execute(new Runnable(){
			@Override
			public void run() {
					QualificationImTemplet templet = constructImInfo(2,"已确认",companyAuditNotice);
					sendMessagesToPur(templet,companyAuditNotice);
			}
        });
    }


    /**
     * 发送消息给采购商
     * @param project
     * @param company
     * @param loginUser
     * @param companyAuditNotice
     */
    private void sendMessagesToPur(QualificationImTemplet templet, CompanyAuditNotice companyAuditNotice) {

        //发送通知
        Message<QualificationImTemplet> message = Message.init(templet)  //传入数据
                .setBusinessTypeCode(IM_CODE)  //业务编码
                .setCompanyCode(companyAuditNotice.getSupCompanySrmCode())   //发送的企业srm编码
                .setMsgLevel(MessageLevelEnum.HIGH)     //消息等级
                .setSenderId(companyAuditNotice.getSupUserId()) //发送人的userid
                .addReceiverId(companyAuditNotice.getPurUserId()); //添加单个收件人 userid
        MessageSendUtils.sendMessage(message);
    }


    /**
     * 查询该角色下的用户
     * @param project
     * @param roleCode
     * @return
     *//*
    private List<String> queryMainUserByAuthName(Project project, String roleCode) {
        if(StringUtils.isBlank(roleCode)){
            throw new CommonException("角色名称不能为空!");
        }
        RoleExample roleExample =new RoleExample();
        roleExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andRoleCodeEqualTo(roleCode)
                .andCompanyIdEqualTo(project.getCompanyId());
        List<Role> roles = roleService.queryAllObjByExample(roleExample);

        if(CollectionUtils.isEmpty(roles)){
            throw new CommonException("权限不存在!");
        }
        Role  role =roles.get(0);
        if(role==null){
            throw new CommonException("权限不存在!");
        }

        UserRoleExample userRoleExample =new UserRoleExample();
        userRoleExample.createCriteria()
                .andRoleIdEqualTo(role.getId());

        List<UserRole> userRoles = userRoleService.queryAllObjByExample(userRoleExample);
        if(CollectionUtils.isEmpty(userRoles)){
            throw new CommonException("用户角色不存在!");
        }
        List<String> userIds=new ArrayList<>();
        for (UserRole userRole : userRoles) {
            if(StringUtils.isNotBlank(userRole.getUserId())){
                userIds.add(userRole.getUserId());
            }
        }
        return userIds;
    }*/


    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    @Override
    public void abolish(List<String> ids) {
        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyAuditNoticeExample companyAuditNoticeExample =new CompanyAuditNoticeExample();

        //判断发送状态
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andSendStatusEqualTo(Constant.NO_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据中包含未发送的数据，操作失败!");
        }


        //判断确认状态
        List<Integer> theseElements = new ArrayList<>();
        theseElements.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        theseElements.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());

        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andConfirmStatusIn(theseElements);

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据中包含已作废或者已确认数据，操作失败!");
        }

        CompanyAuditNotice companyAuditNotice =new CompanyAuditNotice();
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());

        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andSendStatusEqualTo(Constant.YES_INT);

        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice,companyAuditNoticeExample);

    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    @Override
    public void send(List<String> ids) {
        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyAuditNoticeExample companyAuditNoticeExample =new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andSendStatusEqualTo(Constant.YES_INT);

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据中包含已发送数据，不能再操作!");
        }

        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids);
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setSendStatus(Constant.YES_INT);
        //更新状态
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);

        List<CompanyAuditNotice> companyAuditNoticeList =companyAuditNoticeMapper.selectByExample(companyAuditNoticeExample);
        if(CollectionUtils.isEmpty(companyAuditNoticeList)){
            return;
        }
        this.defaultThreadPool.execute(new Runnable(){
			@Override
			public void run() {
				companyAuditNoticeList.forEach(auditNotice ->{
					QualificationImTemplet templet = constructImInfo(1,"已发送",auditNotice);
					//发送消息
					sendMessagesToSup(templet, auditNotice);
				});
			}
        });
    }
    
    /**
     * 消息发送模版设置
     * @param i
     * @param string
     * @param companyAuditNotice
     * @return
     */
    private QualificationImTemplet constructImInfo(int role, String operate, CompanyAuditNotice companyAuditNotice) {
    	Assert.isNotNull(companyAuditNotice, "发送的数据为空");
		QualificationImTemplet qualificationImTemplet = new QualificationImTemplet();
		// 设置角色信息，1为采购商，其他为供应商
		if (1 == role) {
			qualificationImTemplet.setRole("采购商");
			if (StringUtils.isNotBlank(companyAuditNotice.getPurCompanyName())) {
				qualificationImTemplet.setCompanyName(companyAuditNotice.getPurCompanyName());
			} else {
				qualificationImTemplet.setCompanyName("");
			}
		} else {
			qualificationImTemplet.setRole("供应商");
			if (StringUtils.isNotBlank(companyAuditNotice.getSupCompanyName())) {
				qualificationImTemplet.setCompanyName(companyAuditNotice.getSupCompanyName());
			} else {
				qualificationImTemplet.setCompanyName("");
			}
		}
		// 设置操作
		Assert.isNotBlank(operate, "操作字段为空，不能发送消息");
		qualificationImTemplet.setOperate(operate);
		// 设置其他信息
		qualificationImTemplet.setOtherInfo("了现场考察通知单，单据号为：");
		// 设置单据号
		qualificationImTemplet.setBillList(companyAuditNotice.getAuditNoticeNo());
		return qualificationImTemplet;
	}


	/**
     * 发送消息给供应商
     * @param project
     * @param loginUser
     * @param companyAuditNotice
     */
    private void sendMessagesToSup(QualificationImTemplet templet, CompanyAuditNotice companyAuditNotice) {
        //发送通知
        Message<QualificationImTemplet> message = Message.init(templet)  //传入数据
                .setBusinessTypeCode(IM_CODE)  //业务编码
                .setCompanyCode(companyAuditNotice.getPurCompanySrmCode())   //发送的企业srm编码
                .setMsgLevel(MessageLevelEnum.HIGH)     //消息等级
                .setSenderId(companyAuditNotice.getPurUserId()) //发送人的userid
                .addReceiverId(companyAuditNotice.getSupUserId()); //添加单个收件人 userid
        //.addReceiverIdList(new ArrayList<String>()); //添加多个收件人 userid

        MessageSendUtils.sendMessage(message);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(List<String> ids) {
        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyAuditNoticeExample companyAuditNoticeExample =new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andSendStatusEqualTo(Constant.YES_INT);

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据中包含已发送数据，操作失败!");
        }

        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());

        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("单据中包含已确认数据，操作失败!");
        }

        CompanyAuditNotice companyAuditNotice =new CompanyAuditNotice();
        companyAuditNotice.setIsEnable(Constant.NO_INT);

        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria()
                .andIdIn(ids)
                .andSendStatusEqualTo(Constant.NO_INT);
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice,companyAuditNoticeExample);
        // 将准入流程中的现场考察状态清空
        List<CompanyAuditNotice> companyAuditNoticeList = this.queryAllObjByExample(companyAuditNoticeExample);
        Assert.isNotEmpty(companyAuditNoticeList, "查询出的通知单信息为空");
        companyAuditNoticeList.forEach(auditNotice ->{
        	// 根据供应商ID查出准入流程信息
        	Process process = this.processService.queryObjByCompanyId(auditNotice.getSupCompanyId());
        	Assert.isNotNull(process, "根据供应商ID查出的准入流程信息为空");
        	process.setSceneInvestigate(null);
        	this.processService.updateById(process);
        });
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    @Override
    public void insert(Company purCompany, User purUser, CompanyAuditNotice companyAuditNotice) {
        //华阳采购员创建

        //校验数据
        if (companyAuditNotice==null) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        //设置供应商条件
        this.setSupCompanyInfo(companyAuditNotice);

        //设置采购基本信息
        this.setPurCompanyInfo(purCompany, companyAuditNotice);

        //设置单据信息
        this.setCompanyAuditNoticeInfo(purUser, companyAuditNotice);
        
        if (StringUtils.isNotBlank(companyAuditNotice.getAuditInfoFile()) 
        		&& companyAuditNotice.getAuditInfoFile().length() > 3900) {
        	throw new CommonException("上传的附件个数超长，请减少附件个数后再保存");
        }

        if(StringUtils.isEmpty(companyAuditNotice.getId())){
        	// 生成单据号
        	String auditNoticeNo=generateCodeService.getNextCode("AUDIT_NOTICE_NO");
            companyAuditNotice.setAuditNoticeNo(auditNoticeNo);
            this.companyAuditNoticeMapper.insertSelective(companyAuditNotice);
            // 修改准入流程中现场考察的状态为审核中
			Process process = this.processService.queryObjByCompanyId(companyAuditNotice.getSupCompanyId());
			process.setSceneInvestigate(ReviewResultEnum.AUDIT.getCode());
			this.processService.modifyObj(process);
        }else{
        	companyAuditNotice.setUpdateTime(new Date());
            this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);
        }

    }

    /**
     * 设置基本信息
     * @param user
     * @param companyAuditNotice
     */
    private void setCompanyAuditNoticeInfo(User purUser, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setCreateBillName(purUser.getNickName());
        companyAuditNotice.setCreateTime(new Date());
        companyAuditNotice.setPurUserId(purUser.getId());

        //是否可用
        companyAuditNotice.setIsEnable(Constant.YES_INT);

        //发送状态
        companyAuditNotice.setSendStatus(Constant.NO_INT);

        //单据状态:默认为未确认状态
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_UNCONFIRM.getStatus());

        //审核状态:默认状态为未审核
        // companyAuditNotice.setAuditStatus(AuditStatusEnum.NOT_AUDITED.getCode());
    }

    /**
     * 设置采购基本信息
     * @param company
     * @param companyAuditNotice
     */
    private void setPurCompanyInfo(Company company, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setPurCompanyId(company.getId());
        companyAuditNotice.setPurCompanyName(company.getCompanyName());
        companyAuditNotice.setPurCompanyFullName(company.getCompanyFullName());
        companyAuditNotice.setPurCompanySrmCode(company.getCompanyCode());
        companyAuditNotice.setPurCompanySapCode(company.getCompanySapCode());
    }

    /**
     * 设置供应商基本信息
     * @param project
     * @param companyAuditNotice
     */
    private void setSupCompanyInfo(CompanyAuditNotice companyAuditNotice) {
    	// 根据供应商SRM编码查询供应商信息
        Company company = this.companyService.queryCompanyByCode(companyAuditNotice.getSupCompanySrmCode());
        Assert.isNotNull(company, "根据供应商srm编码查询出的供应商信息为空");
        // 根据供应商ID查询供应商用户
        User supUser = this.companyUserRefService.queryMainUserOfCompany(company.getId());
        Assert.isNotNull(supUser, "此供应商没有设置用户信息，新建失败");
        companyAuditNotice.setSupCompanyId(company.getId());
        companyAuditNotice.setSupCompanySrmCode(company.getCompanyCode());
        companyAuditNotice.setSupCompanySapCode(company.getCompanySapCode());
        companyAuditNotice.setSupCompanyName(company.getCompanyName());
        companyAuditNotice.setSupCompanyFullName(company.getCompanyFullName());
        companyAuditNotice.setSupCompanyContacts(company.getContacts());
        companyAuditNotice.setSupCompanyAddress(company.getAddress());
        companyAuditNotice.setSupUserId(supUser.getId());
        // 只现场考察的供应商，新建单据后，供应商的审核状态改为1，不让供应商再修改其基础资料
        Company t = new Company();
        t.setId(company.getId());
        t.setApproveStatus(Constant.YES_INT);
        this.companyService.modifyObj(t);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Override
    public void addObj(CompanyAuditNotice t) {
        this.companyAuditNoticeMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyAuditNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Override
    public void modifyObj(CompanyAuditNotice t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyAuditNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyAuditNotice", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyAuditNotice queryObjById(String id) {
        return this.companyAuditNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyAuditNotice", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyAuditNotice> queryAllObjByExample(CompanyAuditNoticeExample example) {
        return this.companyAuditNoticeMapper.selectByExample(example);
    }

    @Cacheable(value="companyAuditNotice", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyAuditNotice> queryObjByPage(CompanyAuditNoticeExample example) {
        PageView<CompanyAuditNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAuditNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }
}