package com.els.base.certification.notice.web.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Api(value="供应商准入-审核通知单")
@Controller
@RequestMapping("companyAuditNotice")
public class CompanyAuditNoticeController {

    @Resource
    private CompanyAuditNoticeService companyAuditNoticeService;
    
    @Resource
    private CompanyService companyService;
    
    @Resource
    private DicGroupItemService dicGroupItemService;
    
    @Resource
    private ProcessService processService;
    
    @Resource
    private CompanyAuthService companyAuthService;

    @ApiOperation(httpMethod="POST", value="供应商准入--供应商确认审核通知单")
    @RequestMapping("service/confirm")
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody(required=true) CompanyAuditNotice data) {
        Assert.isNotNull(data, "数据为空，操作失败");
        this.companyAuditNoticeService.confirm(data);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="供应商准入--批量作废审核通知单给供应商")
    @RequestMapping("service/abolish")
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyAuditNoticeService.abolish(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="供应商准入--批量发送审核通知单给供应商")
    @RequestMapping("service/send")
    @ResponseBody
    public ResponseResult<String> send(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("发送失败,id不能为空");
        }
        this.companyAuditNoticeService.send(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="创建供应商准入-审核通知单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyAuditNotice companyAuditNotice) {
    	Assert.isNotBlank(companyAuditNotice.getSupCompanySrmCode(), "供应商SRM编码不能为空");
        this.companyAuditNoticeService.insert(CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),companyAuditNotice);
        return ResponseResult.success();
    }

    /*@ApiOperation(httpMethod="POST", value="编辑供应商准入-审核通知单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyAuditNotice companyAuditNotice) {
        if (StringUtils.isBlank(companyAuditNotice.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.companyAuditNoticeService.modifyObj(companyAuditNotice);
        return ResponseResult.success();
    }*/

   /* @ApiOperation(httpMethod="POST", value="删除供应商准入-审核通知单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyAuditNoticeService.deleteObjById(id);
        return ResponseResult.success();
    }*/


    @ApiOperation(httpMethod="POST", value="批量删除供应商准入-审核通知单")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyAuditNoticeService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-审核通知单(采购方)")
    @ApiImplicitParams({ 
         @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
         @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
         @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyAuditNotice", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPage( 
         @RequestParam(defaultValue="0") int pageNo,
         @RequestParam(defaultValue="10") int pageSize,
         @RequestBody(required=false) QueryParamWapper wapper) throws IOException {

        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView(new PageView<CompanyAuditNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();

        //添加查询条件
        criteria.andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
        		.andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId())
                .andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyAuditNotice> pageData = this.companyAuditNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-审核通知单(供应方)")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyAuditNotice", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPageForSup")
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPageForSup(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) throws IOException {

        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView(new PageView<CompanyAuditNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andSendStatusEqualTo(Constant.YES_INT)
                .andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<CompanyAuditNotice> pageData = this.companyAuditNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="新建结果通知单时查询供应商准入-审核通知单消息")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyAuditNotice", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findNoticeByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findNoticeByPage(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) throws IOException {

    	// 查询出供应商已确认的单据供采购商新建结果通知单
        CompanyAuditNoticeExample noticeExample = new CompanyAuditNoticeExample();
        noticeExample.createCriteria()
        	.andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_CONFIRM.getStatus())
        	.andIsEnableEqualTo(Constant.YES_INT);
        List<CompanyAuditNotice> list = this.companyAuditNoticeService.queryAllObjByExample(noticeExample);
        if (CollectionUtils.isEmpty(list)) {
        	return null;
        }
        List<String> companyCodeList = new ArrayList<>(list.size());
        list.forEach(notice ->{
        	companyCodeList.add(notice.getSupCompanySrmCode());
        });
        // 根据供应商编码查询供应商信息
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        companyExample.setPageView(new PageView<Company>(pageNo,pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        criteria.andCompanyCodeIn(companyCodeList).andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<Company> pageData = this.companyService.queryObjByPage(companyExample);
        List<Company> companyList = pageData.getQueryResult();
        PageView<CompanyProcessVO> companyProcessPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
		companyProcessPage.setRowCount(pageData.getRowCount());
        if (CollectionUtils.isEmpty(companyList)) {
        	return ResponseResult.success(companyProcessPage);
        }
        List<CompanyProcessVO> voList = getSuppliers(companyList);
		companyProcessPage.setQueryResult(voList);
		return ResponseResult.success(companyProcessPage);
    }
    
    private List<CompanyProcessVO> getSuppliers(List<Company> companyList) {
		List<CompanyProcessVO> list = new ArrayList<>();
		companyList.forEach(company ->{
			CompanyProcessVO vo = new CompanyProcessVO();
			BeanUtils.copyProperties(company, vo);
			// 设置大类1-大类5
			this.setSecondCompanyType(company, vo);
			// 设置供应商证书信息
			this.setSupplierCertification(vo);
			// 设置准入流程信息
			ProcessExample processExample = new ProcessExample();
			processExample.createCriteria().andCompanyIdEqualTo(company.getId());
			List<Process> processList = processService.queryAllObjByExample(processExample);
			if(CollectionUtils.isNotEmpty(processList)){
				vo.setProcess(processList.get(0));
			}
			
			list.add(vo);
		});
		return list;
	}
    
    /**
	 * 设置供应商证书信息
	 * @param vo
	 */
	private void setSupplierCertification(CompanyProcessVO vo) {
		// 1.设置IATF16949证书信息
		CompanyAuthExample companyAuthExample = new CompanyAuthExample();
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
		List<CompanyAuth> companyAuthList = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList)) {
			CompanyAuth companyAuth1 = companyAuthList.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth1.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth1.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setIATF16949FileName(str);
			vo.setIATF16949Name(companyAuth1.getCertificateFile());
			vo.setIATF16949EndTime(companyAuth1.getEndTime());
		}

		// 2.设置IOS9001证书信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
		List<CompanyAuth> companyAuthList2 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList2)) {
			CompanyAuth companyAuth2 = companyAuthList2.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth2.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth2.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setISO9001FileName(str);
			vo.setISO9001Name(companyAuth2.getCertificateFile());
			vo.setISO9001EndTime(companyAuth2.getEndTime());
		}

		// 3.设置IOS14000证书基本信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
		List<CompanyAuth> companyAuthList3 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList3)) {
			CompanyAuth companyAuth3 = companyAuthList3.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth3.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth3.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setISO14000FileName(str);
			vo.setISO14000Name(companyAuth3.getCertificateFile());
			vo.setISO14000EndTime(companyAuth3.getEndTime());
		}

	}

	/**
	 * 设置大类1-5
	 * @param company
	 * @param vo
	 */
	private void setSecondCompanyType(Company company, CompanyProcessVO vo) {
		String secondCompanyType = company.getSecondCompanyType();
		if (StringUtils.isNotBlank(secondCompanyType)) {
			String[] secondCompanyTypeStr = secondCompanyType.split(",");
			if (ArrayUtils.isNotEmpty(secondCompanyTypeStr)) {

				// 只要前5个
				if (secondCompanyTypeStr.length > 5) {
					vo.setSecondCompanyType1(secondCompanyTypeStr[0]);
					DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[0]);
					if (dicItem1 != null) {
						vo.setSecondCompanyTypeDesc1(dicItem1.getName());
					} else {
						vo.setSecondCompanyTypeDesc1("");
					}

					vo.setSecondCompanyType2(secondCompanyTypeStr[1]);
					DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[1]);
					if (dicItem2 != null) {
						vo.setSecondCompanyTypeDesc2(dicItem2.getName());
					} else {
						vo.setSecondCompanyTypeDesc2("");
					}

					vo.setSecondCompanyType3(secondCompanyTypeStr[2]);
					DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[2]);
					if (dicItem3 != null) {
						vo.setSecondCompanyTypeDesc3(dicItem3.getName());
					} else {
						vo.setSecondCompanyTypeDesc3("");
					}

					vo.setSecondCompanyType4(secondCompanyTypeStr[3]);
					DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[3]);
					if (dicItem4 != null) {
						vo.setSecondCompanyTypeDesc4(dicItem4.getName());
					} else {
						vo.setSecondCompanyTypeDesc4("");
					}
					;

					vo.setSecondCompanyType5(secondCompanyTypeStr[4]);
					DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[4]);
					if (dicItem5 != null) {
						vo.setSecondCompanyTypeDesc5(dicItem5.getName());
					} else {
						vo.setSecondCompanyTypeDesc5("");
					}
				} else {
					for (int i = 1; i <= secondCompanyTypeStr.length; i++) {

						if (i == 1) {
							vo.setSecondCompanyType1(secondCompanyTypeStr[0]);
							DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[0]);
							if (dicItem1 != null) {
								vo.setSecondCompanyTypeDesc1(dicItem1.getName());
							} else {
								vo.setSecondCompanyTypeDesc1("");
							}
						} else if (i == 2) {
							vo.setSecondCompanyType2(secondCompanyTypeStr[1]);
							DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[1]);
							if (dicItem2 != null) {
								vo.setSecondCompanyTypeDesc2(dicItem2.getName());
							} else {
								vo.setSecondCompanyTypeDesc2("");
							}
						} else if (i == 3) {
							vo.setSecondCompanyType3(secondCompanyTypeStr[2]);
							DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[2]);
							if (dicItem3 != null) {
								vo.setSecondCompanyTypeDesc3(dicItem3.getName());
							} else {
								vo.setSecondCompanyTypeDesc3("");
							}
						} else if (i == 4) {
							vo.setSecondCompanyType4(secondCompanyTypeStr[3]);
							DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[3]);
							if (dicItem4 != null) {
								vo.setSecondCompanyTypeDesc4(dicItem4.getName());
							} else {
								vo.setSecondCompanyTypeDesc4("");
							}
						} else if (i == 5) {
							vo.setSecondCompanyType5(secondCompanyTypeStr[4]);
							DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[4]);
							if (dicItem5 != null) {
								vo.setSecondCompanyTypeDesc5(dicItem5.getName());
							} else {
								vo.setSecondCompanyTypeDesc5("");
							}
						} else {

						}

					}
				}

			}
		}

	}
}