package com.els.base.certification.outsourced.service.impl;

import com.els.base.certification.outsourced.dao.OutsourcedMapper;
import com.els.base.certification.outsourced.entity.Outsourced;
import com.els.base.certification.outsourced.entity.OutsourcedExample;
import com.els.base.certification.outsourced.service.OutsourcedService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultOutsourcedService")
public class OutsourcedServiceImpl implements OutsourcedService {
    @Resource
    protected OutsourcedMapper outsourcedMapper;

    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
    public void addObj(Outsourced t) {
        this.outsourcedMapper.insertSelective(t);
    }
    
    @Transactional
    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
	public void batchInserts(String projectId, Company company, List<Outsourced> outsourcedList) {
		if (CollectionUtils.isEmpty(outsourcedList)) {
			return;
		}
    	// 先删除原来的数据
    	OutsourcedExample example = new OutsourcedExample();
    	example.createCriteria().andProjectIdEqualTo(projectId)
    							.andCompanyIdEqualTo(company.getId())
    							.andIsEnableEqualTo(Constant.YES_INT);
    	Outsourced outsourced = new Outsourced();
    	outsourced.setIsEnable(Constant.NO_INT);
    	this.outsourcedMapper.updateByExampleSelective(outsourced, example);
    	// 再批量插入数据
    	outsourcedList.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            item.setProjectId(projectId);
            item.setCompanyId(company.getId());
            item.setCompanySrmCode(company.getCompanyCode());
            item.setIsEnable(Constant.YES_INT);
            item.setCreateTime(new Date());
            
        });
        this.outsourcedMapper.insertBatch(outsourcedList);
		
	}

    @Transactional
    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
    public void addAll(List<Outsourced> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.outsourcedMapper.insertBatch(list);
    }

    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.outsourcedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
    public void deleteByExample(OutsourcedExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.outsourcedMapper.deleteByExample(example);
    }

    @CacheEvict(value={"outsourced"}, allEntries=true)
    @Override
    public void modifyObj(Outsourced t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.outsourcedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="outsourced", keyGenerator="redisKeyGenerator")
    @Override
    public Outsourced queryObjById(String id) {
        return this.outsourcedMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="outsourced", keyGenerator="redisKeyGenerator")
    @Override
    public List<Outsourced> queryAllObjByExample(OutsourcedExample example) {
        return this.outsourcedMapper.selectByExample(example);
    }

    @Cacheable(value="outsourced", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<Outsourced> queryObjByPage(OutsourcedExample example) {
        PageView<Outsourced> pageView = example.getPageView();
        pageView.setQueryResult(this.outsourcedMapper.selectByExampleByPage(example));
        return pageView;
    }

}