package com.els.base.certification.outsourced.web.controller;

import com.els.base.certification.outsourced.entity.Outsourced;
import com.els.base.certification.outsourced.entity.OutsourcedExample;
import com.els.base.certification.outsourced.service.OutsourcedService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商基础资料-外包二级供应商信息")
@Controller
@RequestMapping("outsourced")
public class OutsourcedController {
    @Resource
    protected OutsourcedService outsourcedService;

    @ApiOperation(httpMethod="POST", value="批量创建供应商基础资料-外包二级供应商信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> batchCreate(@RequestBody List<Outsourced> outsourcedList) {
        Assert.isNotEmpty(outsourcedList, "创建的数据为空，操作失败");
        outsourcedList.stream().forEach(outsourced ->{
        	Assert.isNotBlank(outsourced.getBusinessLicense(), "外包商营业执照不能为空");
        	Assert.isNotBlank(outsourced.getQualitySystem(), "外包商营业执照不能为空");
        });
    	this.outsourcedService.batchInserts(ProjectUtils.getProjectId(),CompanyUtils.currentCompany(),outsourcedList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商基础资料-外包二级供应商信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Outsourced outsourced) {
        Assert.isNotBlank(outsourced.getId(), "id 为空，保存失败");
        this.outsourcedService.modifyObj(outsourced);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="批量删除供应商基础资料-外包二级供应商信息")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        OutsourcedExample example = new OutsourcedExample();
        example.createCriteria().andIdIn(ids)
        		.andIsEnableEqualTo(Constant.YES_INT)
        		.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        this.outsourcedService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商基础资料-外包二级供应商信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Outsourced", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Outsourced>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        OutsourcedExample example = new OutsourcedExample();
        example.setPageView(new PageView<Outsourced>(pageNo, pageSize));
        
//        OutsourcedExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<Outsourced> pageData = this.outsourcedService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查询全部供应商基础资料-外包二级供应商信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "companySrmCode",required = false,value = "供应商SRM编码",  dataType = "String"),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Agent", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<Outsourced>> findAll(
    	@RequestParam(required=false) String companySrmCode, 
    	@RequestBody(required=false) QueryParamWapper wapper) {
    	
    	OutsourcedExample example = new OutsourcedExample();
    	OutsourcedExample.Criteria criteria = example.createCriteria();
    	if (StringUtils.isBlank(companySrmCode)) {
    		criteria.andIsEnableEqualTo(Constant.YES_INT)
    				.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
    	} else {
    		criteria.andIsEnableEqualTo(Constant.YES_INT)
    				.andCompanySrmCodeEqualTo(companySrmCode);
    	}
    	if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
    	List<Outsourced> list = this.outsourcedService.queryAllObjByExample(example);
    	return ResponseResult.success(list);
    	
    }
}