package com.els.base.certification.patents.service.impl;

import com.els.base.certification.patents.dao.CompanyPatentsMapper;
import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyPatentsService")
public class CompanyPatentsServiceImpl implements CompanyPatentsService {

    @Resource
    private CompanyPatentsMapper companyPatentsMapper;

    @Cacheable(value="companyPatents", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {

        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyPatentsExample companyPatentsExample =new CompanyPatentsExample();
        //如果数据为空，那么返回0
        companyPatentsExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyPatentsMapper.countByExample(companyPatentsExample);
        if(count<=0){
            return 0;
        }

        companyPatentsExample.clear();
        companyPatentsExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyPatentsMapper.countByExample(companyPatentsExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Transactional
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanyPatents> companyPatentsList) {

        //1.校验数据
        if (CollectionUtils.isEmpty(companyPatentsList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        //2.删除原来的数据
        CompanyPatentsExample companyPatentsExample =new CompanyPatentsExample();
        companyPatentsExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        CompanyPatents companyPatents =new CompanyPatents();
        companyPatents.setIsEnable(Constant.NO_INT);
        this.companyPatentsMapper.updateByExampleSelective(companyPatents,companyPatentsExample);

        List<Integer> list = new ArrayList<Integer>();
        //3.插入现有的数据
        for (CompanyPatents patents : companyPatentsList) {
        	Assert.isNotBlank(patents.getPatentName(), "专利/许可名称不能为空，请正确填写专利/许可名");
        	Assert.isNotNull(patents.getEndTime(), "专利/许可的有效期不能为空，请选择专利/许可的有效期");
        	if ("[]".equals(patents.getPatentFile()) || 
        			StringUtils.isBlank(patents.getPatentFile())) {
        		throw new CommonException("有专利/许可的附件没有上传，请上传附件后再保存");
        	}
            patents.setId(null);
            patents.setProjectId(projectId);
            patents.setSupCompanyId(company.getId());
            patents.setIsEnable(Constant.YES_INT);
            patents.setUpdateTime(new Date());

            if(patents.getCreateTime()==null){
                patents.setCreateTime(new Date());
            }

            Integer finishFlag = patents.getFinishFlag();
            patents.setFinishFlag(finishFlag);
            this.companyPatentsMapper.insertSelective(patents);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanyPatentsExample companyPatentsExample =new CompanyPatentsExample();
        companyPatentsExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(company.getId())
                .andProjectIdEqualTo(projectId).andIdIn(ids);

        CompanyPatents companyPatents =new CompanyPatents();
        companyPatents.setIsEnable(Constant.NO_INT);

        this.companyPatentsMapper.updateByExampleSelective(companyPatents,companyPatentsExample);
    }

    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Override
    public void addObj(CompanyPatents t) {
        this.companyPatentsMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyPatentsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Override
    public void modifyObj(CompanyPatents t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyPatentsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyPatents", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyPatents queryObjById(String id) {
        return this.companyPatentsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyPatents", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyPatents> queryAllObjByExample(CompanyPatentsExample example) {
        return this.companyPatentsMapper.selectByExample(example);
    }

    @Cacheable(value="companyPatents", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyPatents> queryObjByPage(CompanyPatentsExample example) {
        PageView<CompanyPatents> pageView = example.getPageView();
        pageView.setQueryResult(this.companyPatentsMapper.selectByExampleByPage(example));
        return pageView;
    }
}