package com.els.base.certification.process.util;

import org.apache.commons.lang.StringUtils;

/**
 * 供应商完成资质审核、现场考察后，走审批流进行认证，
 * 	认证状态：1未认证，2认证中，3认证成功，4认证失败
 * @author lenovo
 *
 */
public enum AuthenticationEnum {
	/**未认证**/
	UNCERTIFIED(1,"未认证"),
	/**认证中**/
	CERTIFICATION(2,"认证中"),
	/**认证成功**/
	CERTIFICATION_SUCCESS(3,"认证成功"),
	/**认证失败**/
	AUTHENTICATION_FAILURE(4,"认证失败");
	
	private Integer code;
	
	private String name;
	
	public Integer getCode() {
		return code;
	}
	public String getName() {
		return name;
	}
	
	private AuthenticationEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}
	
	public static String getNameForCode(Integer code) {
		String name = "";
		if (null == code){
			return name;
		}
		switch(code) {
		case 1:
			name = AuthenticationEnum.UNCERTIFIED.getName();
			break;
		case 2:
			name = AuthenticationEnum.CERTIFICATION.getName();
			break;
		case 3:
			name = AuthenticationEnum.CERTIFICATION_SUCCESS.getName();
			break;
		case 4:
			name = AuthenticationEnum.AUTHENTICATION_FAILURE.getName();
			break;
		}
		return name;
	}
	
}
