package com.els.base.certification.process.util;

import org.apache.commons.lang.StringUtils;

public enum ReviewResultEnum {
	/**审核中**/
	AUDIT("1","审核中"),
	/**通过**/
	ADOPT("2","通过"),
	/**终止**/
	TERMINATION("3","终止");
	
	private String code;
	
	private String name;

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private ReviewResultEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}
	
	public static String getNameForCode(String code) {
		String name = "";
		if (StringUtils.isBlank(code)) {
			return name;
		}
		switch(code) {
		case "1":
			name = ReviewResultEnum.AUDIT.getName();
			break;
		case "2":
			name = ReviewResultEnum.ADOPT.getName();
			break;
		case "3":
			name = ReviewResultEnum.TERMINATION.getName();
			break;
		}
		return name;
	}
	
}
