package com.els.base.certification.process.vo;

import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModelProperty;

public class SupplierCompanyVO implements Serializable {

	private static final long serialVersionUID = 1L;


    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("公司sap编码")
    private String companySapCode;

    @ApiModelProperty("公司简称")
    private String companyName;

    @ApiModelProperty("公司全称")
    private String companyFullName;

    @ApiModelProperty("公司业务范围")
    private String businessScop;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("移动电话")
    private String mobilephone;

    @ApiModelProperty("固定电话")
    private String telephone;

    @ApiModelProperty("传真")
    private String fax;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("网站")
    private String website;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("采购员")
    private String purchasingStaff;

    @ApiModelProperty("销售员")
    private String salesman;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("供应商服务类")
    private String firstCompanyType;

    @ApiModelProperty("产品大类")
    private String secondCompanyType;

    @ApiModelProperty("企业英文名称")
    private String englishCompanyName;

    @ApiModelProperty("英文地址")
    private String englishAddress;

    @ApiModelProperty("代理品牌")
    private String actingBrand;

    @ApiModelProperty("公司成立时间")
    private Date companyEstablishmentTime;

    @ApiModelProperty("代理证时间")
    private Date agentTime;

    @ApiModelProperty("代理产品")
    private String actingProducts;

    @ApiModelProperty("公司英文简称")
    private String companyEnglishAbbreviation;

    @ApiModelProperty("经营范围")
    private String businessScope;

    @ApiModelProperty("生产地址")
    private String productionAddress;

    @ApiModelProperty("服务类别")
    private String serviceCategory;

	// 准入流程的几个状态
	@ApiModelProperty("认证状态")
	private String isSendName;

	@ApiModelProperty("准入流程")
	private String accessProcessName;

	@ApiModelProperty("资质考察")
	private String qualificationAuditName;

	@ApiModelProperty("现场考察")
	private String sceneInvestigateName;

	@ApiModelProperty("准入流程名称")
	private String processName;

	// 企业认证信息
	@JsonSerialize(using = UploadSupportJsonSerializer.class)
	@JsonDeserialize(using = UploadSupportJsonDeserializer.class)
	@ApiModelProperty(name = "ISO9001体系证书")
	private String ISO9001Name;

	@ApiModelProperty(name = "ISO9001体系证书上传文件名")
	private String ISO9001FileName;

	@ApiModelProperty(name = "ISO9001体系证书有效期")
	private Date ISO9001EndTime;

	@JsonSerialize(using = UploadSupportJsonSerializer.class)
	@JsonDeserialize(using = UploadSupportJsonDeserializer.class)
	@ApiModelProperty(name = "IATF16949体系证书")
	private String IATF16949Name;

	@ApiModelProperty(name = "IATF16949体系证书上传文件名")
	private String IATF16949FileName;

	@ApiModelProperty(name = "IATF16949体系证书有效期")
	private Date IATF16949EndTime;

	@JsonSerialize(using = UploadSupportJsonSerializer.class)
	@JsonDeserialize(using = UploadSupportJsonDeserializer.class)
	@ApiModelProperty(name = "ISO14000体系证书")
	private String ISO14000Name;

	@ApiModelProperty(name = "ISO14000体系证书上传文件名")
	private String ISO14000FileName;

	@ApiModelProperty(name = "ISO14000证书有效期")
	private Date ISO14000EndTime;

	// 大类1-大类5 注册的时候填写的 IC类之类数据
	@ApiModelProperty("公司主营二类型1")
	private String secondCompanyType1;

	@ApiModelProperty("公司主营二类型1说明")
	private String secondCompanyTypeDesc1;

	@ApiModelProperty("公司主营二类型2")
	private String secondCompanyType2;

	@ApiModelProperty("公司主营二类型2说明")
	private String secondCompanyTypeDesc2;

	@ApiModelProperty("公司主营二类型3")
	private String secondCompanyType3;

	@ApiModelProperty("公司主营二类型3说明")
	private String secondCompanyTypeDesc3;

	@ApiModelProperty("公司主营二类型4")
	private String secondCompanyType4;

	@ApiModelProperty("公司主营二类型4说明")
	private String secondCompanyTypeDesc4;

	@ApiModelProperty("公司主营二类型5")
	private String secondCompanyType5;

	@ApiModelProperty("公司主营二类型5说明")
	private String secondCompanyTypeDesc5;
	
	@ApiModelProperty("公司主营一类说明")
    private String  firstCompanyTypeDesc;

	public String getIsSendName() {
		return isSendName;
	}

	public void setIsSendName(String isSendName) {
		this.isSendName = isSendName;
	}

	public String getAccessProcessName() {
		return accessProcessName;
	}

	public void setAccessProcessName(String accessProcessName) {
		this.accessProcessName = accessProcessName;
	}

	public String getQualificationAuditName() {
		return qualificationAuditName;
	}

	public void setQualificationAuditName(String qualificationAuditName) {
		this.qualificationAuditName = qualificationAuditName;
	}

	public String getSceneInvestigateName() {
		return sceneInvestigateName;
	}

	public void setSceneInvestigateName(String sceneInvestigateName) {
		this.sceneInvestigateName = sceneInvestigateName;
	}

	public String getProcessName() {
		return processName;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	public String getISO9001Name() {
		return ISO9001Name;
	}

	public void setISO9001Name(String iSO9001Name) {
		ISO9001Name = iSO9001Name;
	}

	public String getISO9001FileName() {
		return ISO9001FileName;
	}

	public void setISO9001FileName(String iSO9001FileName) {
		ISO9001FileName = iSO9001FileName;
	}

	public Date getISO9001EndTime() {
		return ISO9001EndTime;
	}

	public void setISO9001EndTime(Date iSO9001EndTime) {
		ISO9001EndTime = iSO9001EndTime;
	}

	public String getIATF16949Name() {
		return IATF16949Name;
	}

	public void setIATF16949Name(String iATF16949Name) {
		IATF16949Name = iATF16949Name;
	}

	public String getIATF16949FileName() {
		return IATF16949FileName;
	}

	public void setIATF16949FileName(String iATF16949FileName) {
		IATF16949FileName = iATF16949FileName;
	}

	public Date getIATF16949EndTime() {
		return IATF16949EndTime;
	}

	public void setIATF16949EndTime(Date iATF16949EndTime) {
		IATF16949EndTime = iATF16949EndTime;
	}

	public String getISO14000Name() {
		return ISO14000Name;
	}

	public void setISO14000Name(String iSO14000Name) {
		ISO14000Name = iSO14000Name;
	}

	public String getISO14000FileName() {
		return ISO14000FileName;
	}

	public void setISO14000FileName(String iSO14000FileName) {
		ISO14000FileName = iSO14000FileName;
	}

	public Date getISO14000EndTime() {
		return ISO14000EndTime;
	}

	public void setISO14000EndTime(Date iSO14000EndTime) {
		ISO14000EndTime = iSO14000EndTime;
	}

	public String getSecondCompanyType1() {
		return secondCompanyType1;
	}

	public void setSecondCompanyType1(String secondCompanyType1) {
		this.secondCompanyType1 = secondCompanyType1;
	}

	public String getSecondCompanyTypeDesc1() {
		return secondCompanyTypeDesc1;
	}

	public void setSecondCompanyTypeDesc1(String secondCompanyTypeDesc1) {
		this.secondCompanyTypeDesc1 = secondCompanyTypeDesc1;
	}

	public String getSecondCompanyType2() {
		return secondCompanyType2;
	}

	public void setSecondCompanyType2(String secondCompanyType2) {
		this.secondCompanyType2 = secondCompanyType2;
	}

	public String getSecondCompanyTypeDesc2() {
		return secondCompanyTypeDesc2;
	}

	public void setSecondCompanyTypeDesc2(String secondCompanyTypeDesc2) {
		this.secondCompanyTypeDesc2 = secondCompanyTypeDesc2;
	}

	public String getSecondCompanyType3() {
		return secondCompanyType3;
	}

	public void setSecondCompanyType3(String secondCompanyType3) {
		this.secondCompanyType3 = secondCompanyType3;
	}

	public String getSecondCompanyTypeDesc3() {
		return secondCompanyTypeDesc3;
	}

	public void setSecondCompanyTypeDesc3(String secondCompanyTypeDesc3) {
		this.secondCompanyTypeDesc3 = secondCompanyTypeDesc3;
	}

	public String getSecondCompanyType4() {
		return secondCompanyType4;
	}

	public void setSecondCompanyType4(String secondCompanyType4) {
		this.secondCompanyType4 = secondCompanyType4;
	}

	public String getSecondCompanyTypeDesc4() {
		return secondCompanyTypeDesc4;
	}

	public void setSecondCompanyTypeDesc4(String secondCompanyTypeDesc4) {
		this.secondCompanyTypeDesc4 = secondCompanyTypeDesc4;
	}

	public String getSecondCompanyType5() {
		return secondCompanyType5;
	}

	public void setSecondCompanyType5(String secondCompanyType5) {
		this.secondCompanyType5 = secondCompanyType5;
	}

	public String getSecondCompanyTypeDesc5() {
		return secondCompanyTypeDesc5;
	}

	public void setSecondCompanyTypeDesc5(String secondCompanyTypeDesc5) {
		this.secondCompanyTypeDesc5 = secondCompanyTypeDesc5;
	}

	public String getCompanyCode() {
		return companyCode;
	}

	public void setCompanyCode(String companyCode) {
		this.companyCode = companyCode;
	}

	public String getCompanySapCode() {
		return companySapCode;
	}

	public void setCompanySapCode(String companySapCode) {
		this.companySapCode = companySapCode;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getCompanyFullName() {
		return companyFullName;
	}

	public void setCompanyFullName(String companyFullName) {
		this.companyFullName = companyFullName;
	}

	public String getBusinessScop() {
		return businessScop;
	}

	public void setBusinessScop(String businessScop) {
		this.businessScop = businessScop;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getMobilephone() {
		return mobilephone;
	}

	public void setMobilephone(String mobilephone) {
		this.mobilephone = mobilephone;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getWebsite() {
		return website;
	}

	public void setWebsite(String website) {
		this.website = website;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getContacts() {
		return contacts;
	}

	public void setContacts(String contacts) {
		this.contacts = contacts;
	}

	public String getPurchasingStaff() {
		return purchasingStaff;
	}

	public void setPurchasingStaff(String purchasingStaff) {
		this.purchasingStaff = purchasingStaff;
	}

	public String getSalesman() {
		return salesman;
	}

	public void setSalesman(String salesman) {
		this.salesman = salesman;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getFirstCompanyType() {
		return firstCompanyType;
	}

	public void setFirstCompanyType(String firstCompanyType) {
		this.firstCompanyType = firstCompanyType;
	}

	public String getSecondCompanyType() {
		return secondCompanyType;
	}

	public void setSecondCompanyType(String secondCompanyType) {
		this.secondCompanyType = secondCompanyType;
	}

	public String getEnglishCompanyName() {
		return englishCompanyName;
	}

	public void setEnglishCompanyName(String englishCompanyName) {
		this.englishCompanyName = englishCompanyName;
	}

	public String getEnglishAddress() {
		return englishAddress;
	}

	public void setEnglishAddress(String englishAddress) {
		this.englishAddress = englishAddress;
	}

	public String getActingBrand() {
		return actingBrand;
	}

	public void setActingBrand(String actingBrand) {
		this.actingBrand = actingBrand;
	}

	public Date getCompanyEstablishmentTime() {
		return companyEstablishmentTime;
	}

	public void setCompanyEstablishmentTime(Date companyEstablishmentTime) {
		this.companyEstablishmentTime = companyEstablishmentTime;
	}

	public Date getAgentTime() {
		return agentTime;
	}

	public void setAgentTime(Date agentTime) {
		this.agentTime = agentTime;
	}

	public String getActingProducts() {
		return actingProducts;
	}

	public void setActingProducts(String actingProducts) {
		this.actingProducts = actingProducts;
	}

	public String getCompanyEnglishAbbreviation() {
		return companyEnglishAbbreviation;
	}

	public void setCompanyEnglishAbbreviation(String companyEnglishAbbreviation) {
		this.companyEnglishAbbreviation = companyEnglishAbbreviation;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public String getProductionAddress() {
		return productionAddress;
	}

	public void setProductionAddress(String productionAddress) {
		this.productionAddress = productionAddress;
	}

	public String getServiceCategory() {
		return serviceCategory;
	}

	public void setServiceCategory(String serviceCategory) {
		this.serviceCategory = serviceCategory;
	}

	public String getFirstCompanyTypeDesc() {
		return firstCompanyTypeDesc;
	}

	public void setFirstCompanyTypeDesc(String firstCompanyTypeDesc) {
		this.firstCompanyTypeDesc = firstCompanyTypeDesc;
	}
	
}
