package com.els.base.certification.productservice.entity;

import com.els.base.company.utils.CompanyTypeEnum;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value = "供应商准入-主要产品/服务")
public class CompanyProductService implements Serializable {
//	Logger logger = LoggerFactory.getLogger(CompanyProductService.class);

	// ##########以下非自动生成，请勿覆盖###########
	/*public Integer getFinishFlag(String firstCompanyType) {
		try {
			Class<? extends CompanyProductService> objectClass = this.getClass();
			Field[] fields = objectClass.getDeclaredFields();

			if (ArrayUtils.isEmpty(fields)) {
				logger.info("属性数组为null，返回false");
				return Constant.NO_INT;
			}
			List<String> list = new ArrayList<>();
			list.addAll(this.exculdeFieldNames());
			if (firstCompanyType.equals(CompanyTypeEnum.AGENT.getCode())) {
				list.add("surplusCapacityPercent");//剩余产能百分比
				list.add("mpTime");//产品量产时间
			}
			for (Field field : fields) {
				field.setAccessible(true);
				if (list.contains(field.getName())) {
					continue;
				}
				if (field.get(this) == null) {
					// 有一个为空，就是没有填完
					return Constant.NO_INT;
				}
				// 如果类型是String
				if (field.getType().equals(String.class)) {
					String val = (String) ReflectUtils.getValue(this, field.getName());
					logger.debug("属性[{}]的值是[{}]", field.getName(), val);
					if (StringUtils.isBlank(val)) {
						logger.debug("字符串的值为空，返回false");
						return Constant.NO_INT;
					}
				}
			}
		} catch (IllegalAccessException e) {
			throw new CommonException("检查是否填完资料失败");
		}
		return Constant.YES_INT;
	}
	protected List<String> exculdeFieldNames() {
		List<String> filedNameList = new ArrayList<>();
		filedNameList.add("id");
		filedNameList.add("projectId");
		filedNameList.add("purCompanyId");
		filedNameList.add("purCompanySrmCode");
		filedNameList.add("purCompanyName");
		filedNameList.add("supCompanyId");
		filedNameList.add("supCompanySrmCode");
		filedNameList.add("supCompanyName");
		filedNameList.add("isEnable");
		filedNameList.add("finishFlag");
		filedNameList.add("createTime");
		filedNameList.add("updateTime");
		return filedNameList;
	}*/
	// ####################################

	@ApiModelProperty("主键")
	private String id;

	@ApiModelProperty("项目ID")
	private String projectId;

	@ApiModelProperty("采购商公司ID")
	private String purCompanyId;

	@ApiModelProperty("采购商SRM编码")
	private String purCompanySrmCode;

	@ApiModelProperty("采购商名称")
	private String purCompanyName;

	@ApiModelProperty("供应商ID")
	private String supCompanyId;

	@ApiModelProperty("供应商SRM编码")
	private String supCompanySrmCode;

	@ApiModelProperty("供应商名称")
	private String supCompanyName;

	@ApiModelProperty("主要产品/服务名称")
	private String productServiceName;

	@ApiModelProperty("年生产数量")
	private BigDecimal productQuantity;

	@ApiModelProperty("销售额")
	private BigDecimal saleAmount;

	@ApiModelProperty("该产品/服务占企业总销售额的百分比")
	private BigDecimal salePercent;

	@ApiModelProperty("剩余产能百分比")
	private BigDecimal surplusCapacityPercent;

	@ApiModelProperty("产品量产的时间")
	private String mpTime;

	@ApiModelProperty("正常采购周期")
	private String purchaseCycle;

	@ApiModelProperty("说明")
	private String explaination;

	@ApiModelProperty("记录是否可用(0=不可用，1=可用)")
	private Integer isEnable;

	@ApiModelProperty("完成标识符(0=未完成，1=已完成)")
	private Integer finishFlag;

	@ApiModelProperty("创建时间")
	private Date createTime;

	@ApiModelProperty("修改时间")
	private Date updateTime;

	private static final long serialVersionUID = 1L;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id == null ? null : id.trim();
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId == null ? null : projectId.trim();
	}

	public String getPurCompanyId() {
		return purCompanyId;
	}

	public void setPurCompanyId(String purCompanyId) {
		this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
	}

	public String getPurCompanySrmCode() {
		return purCompanySrmCode;
	}

	public void setPurCompanySrmCode(String purCompanySrmCode) {
		this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
	}

	public String getPurCompanyName() {
		return purCompanyName;
	}

	public void setPurCompanyName(String purCompanyName) {
		this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
	}

	public String getSupCompanyId() {
		return supCompanyId;
	}

	public void setSupCompanyId(String supCompanyId) {
		this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
	}

	public String getSupCompanySrmCode() {
		return supCompanySrmCode;
	}

	public void setSupCompanySrmCode(String supCompanySrmCode) {
		this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
	}

	public String getSupCompanyName() {
		return supCompanyName;
	}

	public void setSupCompanyName(String supCompanyName) {
		this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
	}

	public String getProductServiceName() {
		return productServiceName;
	}

	public void setProductServiceName(String productServiceName) {
		this.productServiceName = productServiceName == null ? null : productServiceName.trim();
	}

	public BigDecimal getProductQuantity() {
		return productQuantity;
	}

	public void setProductQuantity(BigDecimal productQuantity) {
		this.productQuantity = productQuantity;
	}

	public BigDecimal getSaleAmount() {
		return saleAmount;
	}

	public void setSaleAmount(BigDecimal saleAmount) {
		this.saleAmount = saleAmount;
	}

	public BigDecimal getSalePercent() {
		return salePercent;
	}

	public void setSalePercent(BigDecimal salePercent) {
		this.salePercent = salePercent;
	}

	public BigDecimal getSurplusCapacityPercent() {
		return surplusCapacityPercent;
	}

	public void setSurplusCapacityPercent(BigDecimal surplusCapacityPercent) {
		this.surplusCapacityPercent = surplusCapacityPercent;
	}

	public String getMpTime() {
		return mpTime;
	}

	public void setMpTime(String mpTime) {
		this.mpTime = mpTime == null ? null : mpTime.trim();
	}

	public String getPurchaseCycle() {
		return purchaseCycle;
	}

	public void setPurchaseCycle(String purchaseCycle) {
		this.purchaseCycle = purchaseCycle == null ? null : purchaseCycle.trim();
	}

	public String getExplaination() {
		return explaination;
	}

	public void setExplaination(String explaination) {
		this.explaination = explaination == null ? null : explaination.trim();
	}

	public Integer getIsEnable() {
		return isEnable;
	}

	public void setIsEnable(Integer isEnable) {
		this.isEnable = isEnable;
	}

	public Integer getFinishFlag() {
		return finishFlag;
	}

	public void setFinishFlag(Integer finishFlag) {
		this.finishFlag = finishFlag;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
}