package com.els.base.certification.productservice.service;

import java.util.List;

import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface CompanyProductServiceService extends BaseService<CompanyProductService, CompanyProductServiceExample, String> {
	/**
	 * 批量添加产品服务
     * @param company
     * @param projectId
     * @param productServiceList
     */
	Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyProductService> productServiceList);
	
	/**
	 * 删除数据
	 * @param projectId
	 * @param company
	 * @param ids
	 */
	void deleteObjByIds(String projectId, Company company, List<String> ids);

	/**
	 * 判断资料是否填写完整
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
}