package com.els.base.certification.qualification.service;

import java.util.List;

import com.els.base.certification.qualification.entity.Qualification;
import com.els.base.certification.qualification.entity.QualificationExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;

public interface QualificationService extends BaseService<Qualification, QualificationExample, String> {
	/**
	 * 新建资质审核单
	 * @param user
	 * @param qualification
	 */
	public void insert(User user, Qualification qualification,Company purCompany);
	
	/**
	 * 批量删除资质审核单据
	 * @param ids
	 */
	public void deleteObjByIds(List<String> ids);
	
	/**
	 * 采购方修改单据
	 * @param qualification
	 */
	public void purModifyObj(Qualification qualification);
	/**
	 * 供应商修改单据
	 * @param qualification
	 */
	public void supModifyObj(Qualification qualification);
	
	/**
	 * 采购商向供应商批量发送单据
	 * @param projectId
	 * @param loginUser
	 * @param ids
	 */
	public void purSendToSup(List<String> ids);
	
	/**
	 * 供应商向采购商批量发送单据
	 * @param projectId
	 * @param loginUser
	 * @param ids
	 */
	public void supSendToPur(List<String> ids);
	
	/**
	 * 采购商批量审核单据
	 * @param projectId
	 * @param loginUser
	 * @param ids
	 */
	public void checkObjByIds(List<String> ids);
	
	/**
	 * 采购商驳回单据
	 * @param qualification
	 */
	public void rejectObjByIds(Qualification qualification);
	
	/**
	 * 采购商批量终止审核单据
	 * @param projectId
	 * @param loginUser
	 * @param ids
	 */
	public void terminationAuditObjByIds(List<String> ids);
	
	/**
	 * 采购批量撤回单据，返回上一次单据的状态
	 * @param ids
	 */
	public void revokeObjByIds(List<String> ids);
}