package com.els.base.certification.qualification.service.impl;

import com.els.base.certification.qualification.dao.QualificationItemMapper;
import com.els.base.certification.qualification.entity.QualificationItem;
import com.els.base.certification.qualification.entity.QualificationItemExample;
import com.els.base.certification.qualification.service.QualificationItemService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultQualificationItemService")
public class QualificationItemServiceImpl implements QualificationItemService {
    @Resource
    protected QualificationItemMapper qualificationItemMapper;

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    @Override
    public void addObj(QualificationItem t) {
        this.qualificationItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.qualificationItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    @Override
    public void modifyObj(QualificationItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.qualificationItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="qualificationItem", keyGenerator="redisKeyGenerator")
    @Override
    public QualificationItem queryObjById(String id) {
        return this.qualificationItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualificationItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualificationItem> queryAllObjByExample(QualificationItemExample example) {
        return this.qualificationItemMapper.selectByExample(example);
    }

    @Cacheable(value="qualificationItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualificationItem> queryObjByPage(QualificationItemExample example) {
        PageView<QualificationItem> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationItemMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @CacheEvict(value={"qualificationItem"}, allEntries=true)
	@Override
	public void deleteByExample(QualificationItemExample qualificationItemExample) {
		this.qualificationItemMapper.deleteByExample(qualificationItemExample);
	}
}