package com.els.base.certification.qualificationssm.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel(value="资质审核与现场考察模版表")
public class QualificationsSM implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    private String projectId;

    @ApiModelProperty("模板编号")
    private String templatCode;

    @ApiModelProperty("模板名字")
    private String templatName;

    @ApiModelProperty("供应商分类")
    private String supplierLevel;

    @ApiModelProperty("文件说明")
    private String auditStatement;

    @ApiModelProperty("备注")
    private String templateRemark;

    @ApiModelProperty("创建模板人")
    private String establishName;

    @ApiModelProperty("模板类别（区别资质审核模版或现场考察模版）")
    private String templateCategory;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("是否可用")
    private Integer isEnable;
    
    @ApiModelProperty("供应商分类编码")
    private String supplierLevelCode;
    
    @ApiModelProperty("数据是否启用（0不启用，1启用）")
    private Integer isUsable;
    
    private List<QualificationsSMFlie> qualificationsSMFlielist;

    public List<QualificationsSMFlie> getQualificationsSMFlielist() {
		return qualificationsSMFlielist;
	}

	public void setQualificationsSMFlielist(List<QualificationsSMFlie> qualificationsSMFlielist) {
		this.qualificationsSMFlielist = qualificationsSMFlielist;
	}

	private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getTemplatCode() {
        return templatCode;
    }

    public void setTemplatCode(String templatCode) {
        this.templatCode = templatCode == null ? null : templatCode.trim();
    }

    public String getTemplatName() {
        return templatName;
    }

    public void setTemplatName(String templatName) {
        this.templatName = templatName == null ? null : templatName.trim();
    }

    public String getSupplierLevel() {
        return supplierLevel;
    }

    public void setSupplierLevel(String supplierLevel) {
        this.supplierLevel = supplierLevel == null ? null : supplierLevel.trim();
    }

    public String getAuditStatement() {
        return auditStatement;
    }

    public void setAuditStatement(String auditStatement) {
        this.auditStatement = auditStatement == null ? null : auditStatement.trim();
    }

    public String getTemplateRemark() {
        return templateRemark;
    }

    public void setTemplateRemark(String templateRemark) {
        this.templateRemark = templateRemark == null ? null : templateRemark.trim();
    }

    public String getEstablishName() {
        return establishName;
    }

    public void setEstablishName(String establishName) {
        this.establishName = establishName == null ? null : establishName.trim();
    }

    public String getTemplateCategory() {
        return templateCategory;
    }

    public void setTemplateCategory(String templateCategory) {
        this.templateCategory = templateCategory == null ? null : templateCategory.trim();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }
    
    public String getSupplierLevelCode() {
        return supplierLevelCode;
    }

    public void setSupplierLevelCode(String supplierLevelCode) {
        this.supplierLevelCode = supplierLevelCode == null ? null : supplierLevelCode.trim();
    }

    public Integer getIsUsable() {
        return isUsable;
    }

    public void setIsUsable(Integer isUsable) {
        this.isUsable = isUsable;
    }
}