package com.els.base.certification.qualificationssm.service.impl;

import com.els.base.certification.qualificationssm.dao.QualificationsSMFlieMapper;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultQualificationsSMFlieService")
public class QualificationsSMFlieServiceImpl implements QualificationsSMFlieService {
    @Resource
    protected QualificationsSMFlieMapper qualificationsSMFlieMapper;

    @CacheEvict(value={"qualificationsSMFlie"}, allEntries=true)
    @Override
    public void addObj(QualificationsSMFlie t) {
        this.qualificationsSMFlieMapper.insertSelective(t);
    }
    
    @CacheEvict(value={"qualificationsSMFlie"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.qualificationsSMFlieMapper.deleteByPrimaryKey(id);
    }
    @CacheEvict(value={"qualificationsSMFlie"}, allEntries=true)
    @Override
    public void modifyObj(QualificationsSMFlie t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.qualificationsSMFlieMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="qualificationsSMFlie", keyGenerator="redisKeyGenerator")
    @Override
    public QualificationsSMFlie queryObjById(String id) {
        return this.qualificationsSMFlieMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualificationsSMFlie", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualificationsSMFlie> queryAllObjByExample(QualificationsSMFlieExample example) {
        return this.qualificationsSMFlieMapper.selectByExample(example);
    }

    @Cacheable(value="qualificationsSMFlie", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualificationsSMFlie> queryObjByPage(QualificationsSMFlieExample example) {
        PageView<QualificationsSMFlie> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationsSMFlieMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Cacheable(value="qualificationsSMFlie", keyGenerator="redisKeyGenerator")
	@Override
	public int Softdeletions(String id) {
		return this.qualificationsSMFlieMapper.Softdeletions(id);
		
	}
    
    @Cacheable(value="qualificationsSMFlie", keyGenerator="redisKeyGenerator")
	@Override
	public List<QualificationsSMFlie> selectTemplatId(String id) {
		// TODO Auto-generated method stub
		return this.qualificationsSMFlieMapper.selectTemplatId(id);
	}
}