package com.els.base.certification.qualificationssm.service.impl;

import com.els.base.certification.management.entity.ProcessManagementExample;
import com.els.base.certification.management.entity.ProcessManagementExample.Criteria;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.qualificationssm.dao.QualificationsSMMapper;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMExample;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultQualificationsSMService")
public class QualificationsSMServiceImpl implements QualificationsSMService {
    @Resource
    protected QualificationsSMMapper qualificationsSMMapper;

    @Resource
    protected QualificationsSMFlieService qualificationsSMFlieService;
    
    @Resource
    protected ProcessManagementService processManagementService;
    
    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    @Override
    public void addObj(QualificationsSM t) {
    	Assert.isNotNull(t, "新增数据不能为空");
    	QualificationsSMExample example = new QualificationsSMExample();
    	example.createCriteria().andTemplatCodeEqualTo(t.getTemplatCode())
    		.andIsEnableEqualTo(Constant.YES_INT)
    		.andTemplateCategoryEqualTo(t.getTemplateCategory());
    	if (this.qualificationsSMMapper.countByExample(example) > 0) {
    		throw new CommonException("模版编号"+t.getTemplatCode()+"已存在，不能在使用此编号");
    	}
    	t.setCreateTime(new Date());
    	t.setUpdateTime(new Date());
    	t.setIsEnable(Constant.YES_INT);
    	qualificationsSMMapper.insertSelective(t);
    	if (CollectionUtils.isNotEmpty(t.getQualificationsSMFlielist())) {
    	for (QualificationsSMFlie qualificationsSMFlie : t.getQualificationsSMFlielist()) {
    		qualificationsSMFlie.setCreateTime(new Date());
    		qualificationsSMFlie.setUpdateTime(new Date());
    		qualificationsSMFlie.setIsEnable(Constant.YES_INT);
    		qualificationsSMFlie.setTemplatId(t.getId());
    	}
    	qualificationsSMFlieService.addAll(t.getQualificationsSMFlielist());
    	}
      
    }
    //删除整条模版数据以及关联附件
    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
    	//软删除
    	QualificationsSM qualificationsSM= qualificationsSMMapper.selectByPrimaryKey(id);
    	qualificationsSMFlieService.Softdeletions(qualificationsSM.getId());
		qualificationsSMMapper.deleteByPrimaryKey(id);
    }
    
    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    @Override
	public void deleteObjByIds(String id) {
    	// 删除之前判断，准入流程管理是否在使用此模版，如果在使用，不能删除
    	ProcessManagementExample processExample = new ProcessManagementExample();
    	ProcessManagementExample.Criteria criteria = processExample.createCriteria();
    	criteria.andQualificationAuditTemplateIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
    	Criteria or = processExample.or();
    	or.andSiteInspectionTemplateIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
    	if (this.processManagementService.countByExample(processExample) > 0) {
    		throw new CommonException("所选模版已在流程管理中使用，删除失败");
    	}
    	QualificationsSM qualificationsSM = new QualificationsSM();
    	qualificationsSM.setId(id);
    	qualificationsSM.setIsEnable(Constant.NO_INT);
    	this.qualificationsSMMapper.updateByPrimaryKeySelective(qualificationsSM);
    	// 删除附件
    	QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
    	fileExample.createCriteria().andTemplatIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
    	List<QualificationsSMFlie> list = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
    	if (CollectionUtils.isEmpty(list)) {
    		return;
    	}
    	for (QualificationsSMFlie qualificationsSMFlie : list) {
    		qualificationsSMFlie.setIsEnable(Constant.NO_INT);
    		this.qualificationsSMFlieService.modifyObj(qualificationsSMFlie);
    	}
		
	}
    
    //修改模版数据以及批量修改对应附件数据
    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    @Override
    public void modifyObj(QualificationsSM t) {
    	Assert.isNotBlank(t.getId(), "ID为空，编辑失败");
    	// 如果修改了模版编号，看它有没有重复
    	QualificationsSM sm = this.qualificationsSMMapper.selectByPrimaryKey(t.getId());
    	if (!sm.getTemplatCode().equals(t.getTemplatCode())) {
    		QualificationsSMExample example = new QualificationsSMExample();
    		example.createCriteria().andTemplatCodeEqualTo(t.getTemplatCode())
    			.andIsEnableEqualTo(Constant.YES_INT)
    			.andTemplateCategoryEqualTo(t.getTemplateCategory());
    		if (this.qualificationsSMMapper.countByExample(example) > 0) {
    			throw new CommonException("模版编号"+ t.getTemplatCode() +"已存在，不能再使用");
    		}
    	}
    	t.setUpdateTime(new Date());
		qualificationsSMMapper.updateByPrimaryKeySelective(t);
		if (CollectionUtils.isNotEmpty(t.getQualificationsSMFlielist())) {
			QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
			fileExample.createCriteria().andTemplatIdEqualTo(t.getId())
				.andIsEnableEqualTo(Constant.YES_INT);
			List<QualificationsSMFlie> fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
			if (CollectionUtils.isEmpty(fileList)) {
				return;
			}
			fileList.forEach(file ->{
				this.qualificationsSMFlieService.deleteObjById(file.getId());
			});
			// 重新添加附件
			for (QualificationsSMFlie qualificationsSMFlie : t.getQualificationsSMFlielist()) {
				qualificationsSMFlie.setId(null);
				qualificationsSMFlie.setCreateTime(new Date());
	    		qualificationsSMFlie.setUpdateTime(new Date());
	    		qualificationsSMFlie.setIsEnable(Constant.YES_INT);
	    		qualificationsSMFlie.setTemplatId(t.getId());
	    	}
	    	qualificationsSMFlieService.addAll(t.getQualificationsSMFlielist());
				
		}
       		
    }
    
    @Cacheable(value="qualificationsSM", keyGenerator="redisKeyGenerator")
    @Override
    public QualificationsSM queryObjById(String id) {
        return this.qualificationsSMMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualificationsSM", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualificationsSM> queryAllObjByExample(QualificationsSMExample example) {
        return this.qualificationsSMMapper.selectByExample(example);
    }

    
    @Cacheable(value="qualificationsSM", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualificationsSM> queryObjByPage(QualificationsSMExample example) {
        PageView<QualificationsSM> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationsSMMapper.selectByExampleByPage(example));
        return pageView;
    }
    
   /* @Cacheable(value="qualificationsSM", keyGenerator="redisKeyGenerator")
	@Override
	public QualificationsSM selectListAll(String id) {
			Assert.isNotNull(id, "ID不能为空");
		return this.qualificationsSMMapper.selectListAll(id);
	}
    */
    //根据模版表id 查询多个附件
    @Cacheable(value="qualificationsSM", keyGenerator="redisKeyGenerator")
    @Override
    public QualificationsSM selectListAll(String id) {
    	QualificationsSM qualificationsSM= qualificationsSMMapper.selectByPrimaryKey(id);
    	qualificationsSM.setQualificationsSMFlielist(qualificationsSMFlieService.selectTemplatId(qualificationsSM.getId()));
        return qualificationsSM;
    }
	
}