package com.els.base.certification.qualificationssm.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMExample;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="资质审核与现场考察模版表")
@Controller
@RequestMapping("qualificationsSM")
public class QualificationsSMController {
    @Resource
    protected QualificationsSMService qualificationsSMService;
    
    @Resource
    protected QualificationsSMFlieService qualificationsSMFlieService;

    @ApiOperation(httpMethod="POST", value="创建资质审核与现场考察模版表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualificationsSM qualificationsSM) {
    	Assert.isNotNull(qualificationsSM, "保存的数据不能为空");
    	Assert.isNotBlank(qualificationsSM.getTemplatCode(), "模版编号不能为空");
    	Assert.isNotBlank(qualificationsSM.getSupplierLevel(),"供应商分类不能为空");
    	Assert.isNotEmpty(qualificationsSM.getQualificationsSMFlielist(), "模版附件信息不能为空");
    	// 判断模版附件信息中上传的附件不能为空
    	qualificationsSM.getQualificationsSMFlielist().forEach(qualificationsSMFlie ->{
    		if (StringUtils.isBlank(qualificationsSMFlie.getDocumentText()) || 
    				("[]").equals(qualificationsSMFlie.getDocumentText())) {
    			throw new CommonException("模版附件信息中有附件未上传，请上传后再执行保存操作，谢谢！");
    		}
    		if (qualificationsSMFlie.getDocumentText().length() > 3500) {
    			throw new CommonException("上传附件个数超出，请减少上传附件个数再保存");
    		}
    	});
    	User user = SpringSecurityUtils.getLoginUser();
    	qualificationsSM.setEstablishName(user.getNickName());
        this.qualificationsSMService.addObj(qualificationsSM);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑资质审核与现场考察模版表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualificationsSM qualificationsSM) {
        Assert.isNotBlank(qualificationsSM.getId(), "id 为空，保存失败");
    	Assert.isNotBlank(qualificationsSM.getTemplatCode(), "模版编号不能为空");
    	Assert.isNotBlank(qualificationsSM.getSupplierLevel(),"供应商分类不能为空");
    	Assert.isNotEmpty(qualificationsSM.getQualificationsSMFlielist(), "模版附件不能为空");
    	// 判断模版附件信息中上传的附件不能为空
    	qualificationsSM.getQualificationsSMFlielist().forEach(qualificationsSMFlie ->{
    		if (StringUtils.isBlank(qualificationsSMFlie.getDocumentText()) || 
    				("[]").equals(qualificationsSMFlie.getDocumentText())) {
    			throw new CommonException("模版附件信息中有附件未上传，请上传后再执行保存操作，谢谢！");
    		}
    	});
        qualificationsSM.setUpdateTime(new Date());
        this.qualificationsSMService.modifyObj(qualificationsSM);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="批量删除资质审核与现场考察模版表")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败，ID不能为空");
        this.qualificationsSMService.deleteObjByIds(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询资质审核与现场考察模版表")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualificationsSM", paramType = "body", dataType = "QueryParamWapper" ),
		@ApiImplicitParam( name = "templateCategory",  value = "识别模版类型", paramType = "query", dataType = "String" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualificationsSM>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper,
		@RequestParam(value="templateCategory") String templateCategory) {
    	Assert.isNotBlank(templateCategory, "模版类别不能为空");
        QualificationsSMExample example = new QualificationsSMExample();
        example.setPageView(new PageView<QualificationsSM>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualificationsSMExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，IS_ENABLE=1为可用的
        criteria.andIsEnableEqualTo(1);
        criteria.andTemplateCategoryEqualTo(templateCategory);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualificationsSM> pageData = this.qualificationsSMService.queryObjByPage(example);
        // 根据模版ID查询附件信息
        if (CollectionUtils.isNotEmpty(pageData.getQueryResult())) {
        	for (QualificationsSM qualificationsSM : pageData.getQueryResult()) {
        		QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
        		fileExample.createCriteria().andTemplatIdEqualTo(qualificationsSM.getId())
        			.andIsEnableEqualTo(Constant.YES_INT);
        		List<QualificationsSMFlie> list = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
        		qualificationsSM.setQualificationsSMFlielist(list);
        	}
        }
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查看单条模版数据对应的附件")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "id",  value = "模版数据id", paramType = "query", dataType = "String" )  
	}) 
    @RequestMapping("service/selectListAll")
    @ResponseBody
    public ResponseResult<QualificationsSM> selectListAll(String id){
    		Assert.isNotBlank(id, "模版数据id不能为空");
    		QualificationsSM data=qualificationsSMService.selectListAll(id);
    		return ResponseResult.success(data);
}

}