package com.els.base.certification.qualificationssm.web.controller;

import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="资质审核与现场考察模版文件保存表")
@Controller
@RequestMapping("qualificationsSMFlie")
public class QualificationsSMFlieController {
    @Resource
    protected QualificationsSMFlieService qualificationsSMFlieService;
    
    @ApiOperation(httpMethod="POST", value="创建资质审核与现场考察模版文件保存表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualificationsSMFlie qualificationsSMFlie) {
    	Assert.isNotNull(qualificationsSMFlie, "附件不能为空");
    	Assert.isNotBlank(qualificationsSMFlie.getDocumentText(), "附件不能为空");
    	qualificationsSMFlie.setCreateTime(new Date());
    	qualificationsSMFlie.setUpdateTime(new Date());
        this.qualificationsSMFlieService.addObj(qualificationsSMFlie);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑资质审核与现场考察模版文件保存表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualificationsSMFlie qualificationsSMFlie) {
    	Assert.isNotNull(qualificationsSMFlie, "附件不能为空");
    	Assert.isNotBlank(qualificationsSMFlie.getId(), "id 为空，保存失败");
    	Assert.isNotBlank(qualificationsSMFlie.getDocumentText(), "附件不能为空");
       	qualificationsSMFlie.setUpdateTime(new Date());
       	
        this.qualificationsSMFlieService.modifyObj(qualificationsSMFlie);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除资质审核与现场考察模版文件保存表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.qualificationsSMFlieService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询资质审核与现场考察模版文件保存表")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualificationsSMFlie", paramType = "body", dataType = "QueryParamWapper" ),
		@ApiImplicitParam( name = "templatId", value = "以模版id查询文件", paramType = "query", dataType = "String" )
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualificationsSMFlie>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper
		//,@RequestParam(value="templatId") String templatId
		) {
        QualificationsSMFlieExample example = new QualificationsSMFlieExample();
        example.setPageView(new PageView<QualificationsSMFlie>(pageNo, pageSize));
        
        QualificationsSMFlieExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andTemplatIdEqualTo(templatId);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualificationsSMFlie> pageData = this.qualificationsSMFlieService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}