package com.els.base.certification.rawmaterial.service.impl;

import com.els.base.certification.rawmaterial.dao.CompanyRawMaterialMapper;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterial;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyRawMaterialService")
public class CompanyRawMaterialServiceImpl implements CompanyRawMaterialService {
    @Resource
    protected CompanyRawMaterialMapper companyRawMaterialMapper;

    @Cacheable(value="companyRawMaterial", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyRawMaterialExample companyRawMaterialExample =new CompanyRawMaterialExample();
        //如果数据为空，那么返回0
        companyRawMaterialExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if(this.companyRawMaterialMapper.countByExample(companyRawMaterialExample)<=0){
            return 0;
        }
        
        //如果数据不为空，那么判断完成状态只要有0，那么返回未完成
        companyRawMaterialExample.clear();
        companyRawMaterialExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int count = this.companyRawMaterialMapper.countByExample(companyRawMaterialExample);
        if(count>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    @Override
    public void addObj(CompanyRawMaterial t) {
        this.companyRawMaterialMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyRawMaterialMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    @Override
    public void modifyObj(CompanyRawMaterial t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyRawMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyRawMaterial", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyRawMaterial queryObjById(String id) {
        return this.companyRawMaterialMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyRawMaterial", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyRawMaterial> queryAllObjByExample(CompanyRawMaterialExample example) {
        return this.companyRawMaterialMapper.selectByExample(example);
    }

    @Cacheable(value="companyRawMaterial", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyRawMaterial> queryObjByPage(CompanyRawMaterialExample example) {
        PageView<CompanyRawMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.companyRawMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
	@Override
	public Integer batchInsert(String projectId, Company supCompany, Company purCompany,
                               List<CompanyRawMaterial> rawMaterialList) {
    	if(CollectionUtils.isEmpty(rawMaterialList)){
			throw new CommonException("操作失败，数据不能为空!");
		}
    	
    	CompanyRawMaterialExample example = new CompanyRawMaterialExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
		   .andSupCompanyIdEqualTo(supCompany.getId())
		   .andIsEnableEqualTo(Constant.YES_INT);
    	
    	CompanyRawMaterial rawMaterial = new CompanyRawMaterial();
    	rawMaterial.setIsEnable(Constant.NO_INT);
    	
    	this.companyRawMaterialMapper.updateByExampleSelective(rawMaterial, example);

        List<Integer> list = new ArrayList<Integer>();

    	for (CompanyRawMaterial companyRawMaterial : rawMaterialList) {
    		companyRawMaterial.setId(null);
			companyRawMaterial.setProjectId(projectId);
			companyRawMaterial.setPurCompanyId(purCompany.getId());
			companyRawMaterial.setPurCompanySrmCode(purCompany.getCompanyCode());
			companyRawMaterial.setPurCompanyName(purCompany.getCompanyName());
			companyRawMaterial.setSupCompanyId(supCompany.getId());
			companyRawMaterial.setSupCompanySrmCode(supCompany.getCompanyCode());
			companyRawMaterial.setSupCompanyName(supCompany.getCompanyName());
			companyRawMaterial.setIsEnable(Constant.YES_INT);
			companyRawMaterial.setCreateTime(new Date());
			companyRawMaterial.setUpdateTime(new Date());
			companyRawMaterial.setFinishFlag(Constant.NO_INT);
			//完成标识,一开始默认是0,0也是非空,不会影响非空判断
			Integer finishFlag = companyRawMaterial.getFinishFlag();
			companyRawMaterial.setFinishFlag(finishFlag);
			this.addObj(companyRawMaterial);

            list.add(finishFlag);

		}

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }
    }
    
    @Transactional
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
	@Override
	public void deleteObjByIds(String projectId, Company company, List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
        	throw new CommonException("传递的id列表为空!");
        }
    	
    	CompanyRawMaterialExample example = new CompanyRawMaterialExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
		   .andSupCompanyIdEqualTo(company.getId())
		   .andIdIn(ids);
    	
    	CompanyRawMaterial rawMaterial = new CompanyRawMaterial();
    	rawMaterial.setIsEnable(Constant.NO_INT);
    	
    	this.companyRawMaterialMapper.updateByExampleSelective(rawMaterial, example);
    }
}