package com.els.base.certification.remind.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商准入-到期提醒供应商信息")
public class RemindInfo implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("证书类型CODE值")
    private String certificateTypeCode;

    @ApiModelProperty("证书名称,类型")
    private String certificateName;

    @ApiModelProperty("到期日期")
    private Date endTime;

    @ApiModelProperty("是否可用（1可用，0不可用）")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("单据状态(1确认，0未确认)")
    private Integer status;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getCertificateTypeCode() {
        return certificateTypeCode;
    }

    public void setCertificateTypeCode(String certificateTypeCode) {
        this.certificateTypeCode = certificateTypeCode == null ? null : certificateTypeCode.trim();
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName == null ? null : certificateName.trim();
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}