package com.els.base.certification.remind.service.impl;

import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.remind.dao.RemindInfoMapper;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultRemindInfoService")
public class RemindInfoServiceImpl implements RemindInfoService {
    @Resource
    protected RemindInfoMapper remindInfoMapper;
    
    @Resource
	private CertificateExpiryService certificateExpiryService;
	
	@Resource
	private CompanyAuthService companyAuthService;
	
	@Resource
	private CompanyService companyService;
	
	@Resource
	private RemindInfoService remindInfoService;

    @CacheEvict(value={"remindInfo"}, allEntries=true)
    @Override
    public void addObj(RemindInfo t) {
        this.remindInfoMapper.insertSelective(t);
    }
    
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    @Override
	public void batchObjByIds(List<String> ids) {
		RemindInfoExample example = new RemindInfoExample();
		example.createCriteria().andIdIn(ids).andStatusEqualTo(Constant.YES_INT);
		if (this.remindInfoMapper.countByExample(example) > 0) {
			throw new CommonException("所选数据包含已确认的，操作失败");
		}
		// 修改单据状态为确认
		example.clear();
		example.createCriteria().andIdIn(ids).andStatusEqualTo(Constant.NO_INT);
		RemindInfo remind = new RemindInfo();
		remind.setStatus(Constant.YES_INT);
		this.remindInfoMapper.updateByExampleSelective(remind, example);
		
	}

    @CacheEvict(value={"remindInfo"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.remindInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"remindInfo"}, allEntries=true)
    @Override
    public void modifyObj(RemindInfo t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.remindInfoMapper.updateByPrimaryKeySelective(t);
    }
    
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    @Override
	public void modifyByExample(RemindInfo remindInfo, RemindInfoExample remindInfoExample) {
		Assert.isNotNull(remindInfo, "参数不能为空");
		this.remindInfoMapper.updateByExampleSelective(remindInfo, remindInfoExample);
		
	}

    @Cacheable(value="remindInfo", keyGenerator="redisKeyGenerator")
    @Override
    public RemindInfo queryObjById(String id) {
        return this.remindInfoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="remindInfo", keyGenerator="redisKeyGenerator")
    @Override
    public List<RemindInfo> queryAllObjByExample(RemindInfoExample example) {
        return this.remindInfoMapper.selectByExample(example);
    }

    @Cacheable(value="remindInfo", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<RemindInfo> queryObjByPage(RemindInfoExample example) {
        PageView<RemindInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.remindInfoMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Cacheable(value="remindInfo", keyGenerator="redisKeyGenerator")
	@Override
	public int countByExample(RemindInfoExample remindInfoExample) {
		int countByExample = this.remindInfoMapper.countByExample(remindInfoExample);
		return countByExample;
	}

}