package com.els.base.certification.result.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.certification.result.util.ResultNoticeEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

@Api(value="供应商准入-审核结果通知单")
@Controller
@RequestMapping("companyResultNotice")
public class CompanyResultNoticeController {

    @Resource
    private CompanyResultNoticeService companyResultNoticeService;

    @ApiOperation(httpMethod="POST", value="创建供应商准入-审核结果通知单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyResultNotice companyResultNotice) {
    	Assert.isNotBlank(companyResultNotice.getSupCompanySrmCode(), "供应商SRM编码不能为空");
        this.companyResultNoticeService.insert(CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(),companyResultNotice);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入-批量删除审核结果通知单")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyResultNoticeService.deleteObjByIds(ids);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入-供应商批量确认审核结果通知单")
    @RequestMapping("service/confirmByIds")
    @ResponseBody
    public ResponseResult<String> confirmByIds(@RequestBody(required=true) CompanyResultNotice data) {
        if (null == data) {
            throw new CommonException("确认失败,数据不能为空");
        }
        this.companyResultNoticeService.supConfirmBill(data);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入--批量通过审核现场考察结果通知单给供应商")
    @RequestMapping("service/throughAudit")
    @ResponseBody
    public ResponseResult<String> throughAudit(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyResultNoticeService.adopt(ids);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入--批量整改现场考察结果通知单给供应商")
    @RequestMapping("service/rectificationByIds")
    @ResponseBody
    public ResponseResult<String> rectificationByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyResultNoticeService.rectification(ids);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入--批量终止审核现场考察结果通知单给供应商")
    @RequestMapping("service/terminationAudit")
    @ResponseBody
    public ResponseResult<String> terminationAudit(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyResultNoticeService.termination(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-审核结果通知单(采购方)")
    @ApiImplicitParams({ 
         @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
         @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
         @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyResultNotice", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPage( 
         @RequestParam(defaultValue="0") int pageNo,
         @RequestParam(defaultValue="10") int pageSize,
         @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView(new PageView<CompanyResultNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");

        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyResultNotice> pageData = this.companyResultNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="查询供应商准入-审核结果通知单(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyResultNotice", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPageForSup")
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPageForSup(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView(new PageView<CompanyResultNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        
        // 只有通过审核、整改、终止审核的单据供应商才能看到
        List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        
        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT)
        		.andConfirmStatusIn(list)
                .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<CompanyResultNotice> pageData = this.companyResultNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "发送供应商审核")
	@RequestMapping("service/sendApproval")
	@ResponseBody
	public ResponseResult<String> sendApproval(@RequestBody List<CompanyProcessVO> list){
		Assert.isNotEmpty(list, "发送数据不能为空");
		this.companyResultNoticeService.sendToApprove(list);
		return ResponseResult.success();
	}
    
    @ApiOperation(httpMethod = "POST", value = "供应商准入-采购商批量撤回单据到上次单据状态")
	@RequestMapping("service/revokeByIds")
	@ResponseBody
	public ResponseResult<String> revokeByIds(@RequestBody List<String> ids){
		Assert.isNotEmpty(ids, "单据ID为空，操作失败");
		this.companyResultNoticeService.revokeObjByIds(ids);
		return ResponseResult.success();
	}

    /*
    @ApiOperation(httpMethod="POST", value="编辑供应商准入-审核结果通知单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyResultNotice companyResultNotice) {
        if (StringUtils.isBlank(companyResultNotice.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.companyResultNoticeService.modifyObj(companyResultNotice);
        return ResponseResult.success();
    }*/

   /* @ApiOperation(httpMethod="POST", value="删除供应商准入-审核结果通知单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyResultNoticeService.deleteObjById(id);
        return ResponseResult.success();
    }*/
    
    /*@ApiOperation(httpMethod="POST", value="供应商准入--批量作废审核结果通知单给供应商")
    @RequestMapping("service/abolish")
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("作废失败,id不能为空");
        }
        this.companyResultNoticeService.abolish(ProjectUtils.getProject(),CompanyUtils.currentCompany(),ids);
        return ResponseResult.success();
    }*/


    /*@ApiOperation(httpMethod="POST", value="供应商准入--批量发送审核结果通知单给供应商")
    @RequestMapping("service/send")
    @ResponseBody
    public ResponseResult<String> send(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("发送失败,id不能为空");
        }
        this.companyResultNoticeService.send(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),ids);
        return ResponseResult.success();
    }*/

}