package com.els.base.certification.suppliercategory.web.controller;

import com.els.base.certification.suppliercategory.dao.SupplierCategoryMapper;
import com.els.base.certification.suppliercategory.entity.SupplierCategory;
import com.els.base.certification.suppliercategory.entity.SupplierCategoryExample;
import com.els.base.certification.suppliercategory.service.SupplierCategoryService;
import com.els.base.certification.suppliercategory.vo.SupCategoryVO;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "供应商分类管理")
@Controller
@RequestMapping("supplierCategory")
public class SupplierCategoryController {
	private static final Integer YES_INABLED = 1;
	@Resource
	protected SupplierCategoryService supplierCategoryService;
	@Resource
	protected SupplierCategoryMapper supplierCategoryMapper;
	@Resource
	protected CompanyService companyService;


	@ApiOperation(httpMethod = "POST", value = "把供应商信息添加到分类中去")
	@RequestMapping("service/addSupCategory")
	@ResponseBody
	public ResponseResult<String> addSupCategory(
			@RequestParam String supplierCategoryId,
			@RequestParam String companyId,
			@RequestParam(required = false,defaultValue = "0") String type) {

		Company company = companyService.queryObjById(companyId);
		if(company == null) {
			throw new CommonException("没有找到此供应商");
		}
		this.supplierCategoryService.addSupCategory(company,supplierCategoryId,type);
		return ResponseResult.success();
	}
	
	@ApiOperation(httpMethod = "POST", value = "批量把供应商信息添加到分类中去")
	@RequestMapping("service/addSupCategorys")
	@ResponseBody
	public ResponseResult<String> addSupCategorys(
			@RequestBody(required = true) List<SupCategoryVO> list,
			@RequestParam(required = false,defaultValue = "0") String type) {

		Assert.isNotEmpty(list,"请选中要操作的单据");
		for (SupCategoryVO supCategoryVO : list) {
			Assert.isNotBlank(supCategoryVO.getCompanyId(),"供应商ID不能为空！");
			Assert.isNotBlank(supCategoryVO.getSupplierCategoryId(),"供应商分类信息ID不能为空！");
		}

		for (SupCategoryVO supCategoryVO : list) {
			Company company = companyService.queryObjById(supCategoryVO.getCompanyId());
			if(company == null) {
				throw new CommonException("没有找到此供应商");
			}
			this.supplierCategoryService.addSupCategory(company,supCategoryVO.getSupplierCategoryId(),type);
		}
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "创建供应商分类管理")
	@RequestMapping("service/create")
	@ResponseBody
	public ResponseResult<String> create(@RequestBody SupplierCategory supplierCategory) {
		if (StringUtils.isEmpty(supplierCategory.getCompanyCategory())) {
			throw new CommonException("分类名称不能为空!");
		}
		if (StringUtils.isEmpty(supplierCategory.getCategoryCode())) {
			throw new CommonException("编码不能为空");
		}

		if (supplierCategory.getCategoryCode().length() > 255) {
			throw new CommonException("供应商分类编码不能超过规定长度", "length_canot_exceed", "供应商分类编码", 255);
		}

		if (supplierCategory.getCompanyCategory().length() > 255) {
			throw new CommonException("供应商分类名称不能超过规定长度", "length_canot_exceed", "供应商分类名称", 255);
		}
		
		supplierCategory.setCreateTime(new Date());
		
		this.supplierCategoryService.addObj(supplierCategory);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "编辑供应商分类管理")
	@RequestMapping("service/edit")
	@ResponseBody
	public ResponseResult<String> edit(@RequestBody SupplierCategory supplierCategory) {
		if (StringUtils.isBlank(supplierCategory.getId())) {
			throw new CommonException("Id为空", "id_is_blank");
		}
		if (StringUtils.isEmpty(supplierCategory.getCompanyCategory())) {
			throw new CommonException("供应商分类名称不能为空!");
		}
		if (StringUtils.isEmpty(supplierCategory.getCategoryCode())) {
			throw new CommonException("供应商分类编码不能为空");
		}
		if (supplierCategory.getCategoryCode().length() > 255) {
			throw new CommonException("供应商分类编码不能超过规定长度", "length_canot_exceed", "供应商分类编码", 255);
		}
		if (supplierCategory.getCompanyCategory().length() > 255) {
			throw new CommonException("供应商分类名称不能超过规定长度", "length_canot_exceed", "供应商分类名称", 255);
		}
		// 判断修改时是否提交了新的供应商分类code
		int flag = 0;

		SupplierCategory obj = this.supplierCategoryService.queryObjById(supplierCategory.getId());
		if (null == obj) {
			throw new CommonException("该id查不到数据");
		} else {
			String categoryCode = obj.getCategoryCode();
			if (StringUtils.isNotBlank(categoryCode) && (!categoryCode.equals(supplierCategory.getCategoryCode()))) {
				// 说明修改时提交了新的code
				flag = 1;
			}
		}

		if (flag == 1) {
			// 提交了新的code,需要判断code值是否存在
			SupplierCategoryExample materialCategoryExample = new SupplierCategoryExample();
			materialCategoryExample.createCriteria()
					.andCategoryCodeEqualTo(supplierCategory.getCategoryCode()).andIsEnableEqualTo(YES_INABLED);
			if (this.supplierCategoryMapper.countByExample(materialCategoryExample) > 0) {
				throw new CommonException("该供应商分类编码已存在!");
			}
		}

		supplierCategory.setUpdateTime(new Date());

		this.supplierCategoryService.modifyObj(supplierCategory);
		return ResponseResult.success();
	}

	@Transactional
	@ApiOperation(httpMethod = "POST", value = "删除供应商分类")
	@RequestMapping("service/deleteById")
	@ResponseBody
	public ResponseResult<String> deleteById(@ApiParam(value = "分类ID") @RequestParam(required = true) String id) {
		Assert.isNotBlank(id, "删除失败,id不能为空");
		this.supplierCategoryService.deleteObjById(id);
		//this.supplierCategoryService.deleteCascadedMaterialCategoryInfo(id);

		SupplierCategoryExample example = new SupplierCategoryExample();
		example.createCriteria().andParentIdEqualTo(id);
		if (this.supplierCategoryMapper.countByExample(example) > 0) {
			List<SupplierCategory> list = this.supplierCategoryService.queryAllObjByExample(example);
			for (SupplierCategory supplierCategory : list) {
				this.supplierCategoryService.deleteCascadedMaterialCategoryInfo(supplierCategory.getId());
			}
		}
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "查询所有的供应商分类信息及关联的子供应商分类信息")
	@RequestMapping("service/findAllSupplierCategoryInfo")
	@ResponseBody
	public ResponseResult<List<SupplierCategory>> findAllMaterialCategoryInfo() {
		SupplierCategoryExample example = new SupplierCategoryExample();
		example.setOrderByClause("CREATE_TIME DESC");
		example.createCriteria().andIsEnableEqualTo(YES_INABLED)
				.andParentIdIsNull();
		List<SupplierCategory> supplierCategoryList = this.supplierCategoryService.queryAllObjByExample(example);
		for (SupplierCategory supplierCategory : supplierCategoryList) {
			supplierCategory.setSupplierCategoryList(this.supplierCategoryService.queryByParentId(supplierCategory.getId()));
		}
		return ResponseResult.success(supplierCategoryList);
	}
	
	
	
	@ApiOperation(httpMethod="POST", value="分页查询")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 SupAuthentication", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierCategory>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
		SupplierCategoryExample example = new SupplierCategoryExample();
        example.setPageView(new PageView<SupplierCategory>(pageNo, pageSize));
        SupplierCategoryExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<SupplierCategory> pageData = this.supplierCategoryService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

	
	
	@ApiOperation(httpMethod = "POST", value = "根据id查询应商分类信息")
	@RequestMapping("service/findById")
	@ResponseBody
	public ResponseResult<List<SupplierCategory>> findById(@RequestParam String id) {
		Assert.isNotBlank(id, "id不能为空");
		List<SupplierCategory> supplierCategoryList = this.supplierCategoryService.queryByParentId(id);
		
		return ResponseResult.success(supplierCategoryList);
	}
	
	@ApiOperation(httpMethod = "POST", value = "根据id查询应商分类信息")
	@RequestMapping("service/queryById")
	@ResponseBody
	public ResponseResult<SupplierCategory> queryById(@RequestParam String id) {
		Assert.isNotBlank(id, "id不能为空");
		SupplierCategory supplierCategory = this.supplierCategoryService.queryObjById(id);
		
		return ResponseResult.success(supplierCategory);
	}
}
