package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.ChangePatentsAndAgentMapper;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgent;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgentExample;
import com.els.base.certification.supplierchangesheet.service.ChangePatentsAndAgentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultChangePatentsAndAgentService")
public class ChangePatentsAndAgentServiceImpl implements ChangePatentsAndAgentService {
    @Resource
    protected ChangePatentsAndAgentMapper changePatentsAndAgentMapper;

    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    @Override
    public void addObj(ChangePatentsAndAgent t) {
        this.changePatentsAndAgentMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    @Override
    public void addAll(List<ChangePatentsAndAgent> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.changePatentsAndAgentMapper.insertBatch(list);
    }

    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.changePatentsAndAgentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    @Override
    public void deleteByExample(ChangePatentsAndAgentExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.changePatentsAndAgentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    @Override
    public void modifyObj(ChangePatentsAndAgent t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.changePatentsAndAgentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="changePatentsAndAgent", keyGenerator="redisKeyGenerator")
    @Override
    public ChangePatentsAndAgent queryObjById(String id) {
        return this.changePatentsAndAgentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="changePatentsAndAgent", keyGenerator="redisKeyGenerator")
    @Override
    public List<ChangePatentsAndAgent> queryAllObjByExample(ChangePatentsAndAgentExample example) {
        return this.changePatentsAndAgentMapper.selectByExample(example);
    }

    @Cacheable(value="changePatentsAndAgent", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ChangePatentsAndAgent> queryObjByPage(ChangePatentsAndAgentExample example) {
        PageView<ChangePatentsAndAgent> pageView = example.getPageView();
        pageView.setQueryResult(this.changePatentsAndAgentMapper.selectByExampleByPage(example));
        return pageView;
    }
}