package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.SupAuthenticationMapper;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultSupAuthenticationService")
public class SupAuthenticationServiceImpl implements SupAuthenticationService {
    @Resource
    protected SupAuthenticationMapper supAuthenticationMapper;

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    @Override
    public void addObj(SupAuthentication t) {
        this.supAuthenticationMapper.insertSelective(t);
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.supAuthenticationMapper.deleteByPrimaryKey(id);
    }
    
    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    @Override
    public void deleteObjBychangeBillNo(String changeBillNo) {
        this.supAuthenticationMapper.deleteByChangeBillNo(changeBillNo);
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    @Override
    public void modifyObj(SupAuthentication t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.supAuthenticationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
    @Override
    public SupAuthentication queryObjById(String id) {
        return this.supAuthenticationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
    @Override
    public List<SupAuthentication> queryAllObjByExample(SupAuthenticationExample example) {
        return this.supAuthenticationMapper.selectByExample(example);
    }

    @Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<SupAuthentication> queryObjByPage(SupAuthenticationExample example) {
        PageView<SupAuthentication> pageView = example.getPageView();
        pageView.setQueryResult(this.supAuthenticationMapper.selectByExampleByPage(example));
        return pageView;
    }

	

    @Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
    @Override
	public void deleteByChangeBillNo(String changeBillNo) {
		this.supAuthenticationMapper.deleteByChangeBillNo(changeBillNo);
	}

    @Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
    @Override
	public List<SupAuthentication> selectBill(String changeBillNo) {
		List<SupAuthentication> selectBill = this.supAuthenticationMapper.selectBill(changeBillNo);
		return selectBill;
	}



	@Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
	@Override
	public void addAttachment(SupAuthentication supAuthentication) {
			String id = supAuthentication.getId();
			if (org.springframework.util.StringUtils.isEmpty(id)) {
				throw new CommonException("合同模板ID不能为空");
			}
			supAuthenticationMapper.updateByPrimaryKeySelective(supAuthentication);
		

	}
	
	
	
	
	@Cacheable(value="supAuthentication", keyGenerator="redisKeyGenerator")
	@Override
	public List<SupAuthentication> selectEffective( ) {
			
			return supAuthenticationMapper.selectEffective();
		

	}
	
	
	
	
	
	
}