package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetDETAILEMapper;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILE;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILEExample;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.core.entity.PageView;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultSupplierChangeSheetDETAILEService")
public class SupplierChangeSheetDETAILEServiceImpl implements SupplierChangeSheetDETAILEService {
    @Resource
    protected SupplierChangeSheetDETAILEMapper supplierChangeSheetDETAILEMapper;

    @CacheEvict(value={"supplierChangeSheetDETAILE"}, allEntries=true)
    @Override
    public void addObj(SupplierChangeSheetDETAILE t) {
        this.supplierChangeSheetDETAILEMapper.insertSelective(t);
    }

    @CacheEvict(value={"supplierChangeSheetDETAILE"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.supplierChangeSheetDETAILEMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supplierChangeSheetDETAILE"}, allEntries=true)
    @Override
    public void modifyObj(SupplierChangeSheetDETAILE t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.supplierChangeSheetDETAILEMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="supplierChangeSheetDETAILE", keyGenerator="redisKeyGenerator")
    @Override
    public SupplierChangeSheetDETAILE queryObjById(String id) {
        return this.supplierChangeSheetDETAILEMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="supplierChangeSheetDETAILE", keyGenerator="redisKeyGenerator")
    @Override
    public List<SupplierChangeSheetDETAILE> queryAllObjByExample(SupplierChangeSheetDETAILEExample example) {
        return this.supplierChangeSheetDETAILEMapper.selectByExample(example);
    }

    @Cacheable(value="supplierChangeSheetDETAILE", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<SupplierChangeSheetDETAILE> queryObjByPage(SupplierChangeSheetDETAILEExample example) {
        PageView<SupplierChangeSheetDETAILE> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierChangeSheetDETAILEMapper.selectByExampleByPage(example));
        return pageView;
    }
    @Cacheable(value="supplierChangeSheetDETAILE", keyGenerator="redisKeyGenerator")
	@Override
	public List<SupplierChangeSheetDETAILE> selectBill(String bill) {
		 List<SupplierChangeSheetDETAILE> selectBill = this.supplierChangeSheetDETAILEMapper.selectBill(bill);
		 
		 return selectBill;
	}
    
    @CacheEvict(value={"supplierChangeSheetDETAILE"}, allEntries=true)
	@Override
	public void deleteByChangeBillNo(String changeBillNo) {
		this.supplierChangeSheetDETAILEMapper.deleteByChangeBillNo(changeBillNo);		
	}

}