package com.els.base.certification.supplierchangesheet.service.impl;
import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetMapper;
import com.els.base.certification.supplierchangesheet.emum.ApproveStatus;
import com.els.base.certification.supplierchangesheet.emum.ChangType;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgent;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgentExample;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILE;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILEExample;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.certification.supplierchangesheet.service.ChangePatentsAndAgentService;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
@Service("defaultSupplierChangeSheetService")
public class SupplierChangeSheetServiceImpl implements SupplierChangeSheetService,ITaskListener{
   
	private Logger logger = LoggerFactory.getLogger(SupplierChangeSheetServiceImpl.class);
	
	@Resource
	protected SupplierChangeSheetMapper supplierChangeSheetMapper;
	
	@Resource
	protected GenerateCodeService generatecodeservice;
	
	@Resource
	protected SupplierChangeSheetDETAILEService SupplierChangeSheetDetaleService;
	
	@Resource
    protected SupAuthenticationService supAuthenticationService;
	
	@Resource
	protected WorkFlowService workFlowService;
	
	@Resource
	protected ChangePatentsAndAgentService changePatentsAndAgentService;
	
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void addObj(SupplierChangeSheet t) {
		this.supplierChangeSheetMapper.insertSelective(t);
	}
	
	@Transactional
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void insert(SupplierChangeSheet t, User loginUser,Company company) {
		Assert.isNotNull(t, "变更单内容不能为空");
		Assert.isNotNull(t.getSupplierChangeSheetDetaileList(), "变更内容不能为空否则无法生成供应商信息变更单");
		
		String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
		t.setChangeBillNo(ChangeBillNos);
		t.setConfirmTime(new Date());
		t.setConfirmBillName(loginUser.getNickName());
		t.setSupplierSapCode(company.getCompanySapCode());
		t.setSupCompanyId(company.getCompanyCode());
		t.setSupplierName(company.getCompanyName());
		t.setChangType(ChangType.INFORMATION.getCode());
		t.setUpdateTime(new Date());
		t.setCreateBillTime(new Date());
		if (t.getSupplierChangeSheetDetaileList().size() > 0 && !t.getSupplierChangeSheetDetaileList().isEmpty()) {
			List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
			for (int i = 0; i < list.size(); i++) {
				SupplierChangeSheetDETAILE supplierChangeSheetDETAILE = list.get(i);
				supplierChangeSheetDETAILE.setChangeBillNo(ChangeBillNos);
				supplierChangeSheetDETAILE.setCreateTime(new Date());
				String content = supplierChangeSheetDETAILE.getContent();
				String changeContent = supplierChangeSheetDETAILE.getChangeContent();
				if (content.equals(changeContent)) {
					throw new CommonException("原内容与更改内容不能相同");
				}
			}
			this.SupplierChangeSheetDetaleService.addAll(list);
			this.supplierChangeSheetMapper.insertSelective(t);
		}
		
	}
	
	@Transactional
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void addCertification(SupplierChangeSheet t, User loginUser,Company company) {
		Assert.isNotNull(t, "变更单内容不能为空");
		// 生成变更单号
		String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
		t.setChangeBillNo(ChangeBillNos);
		t.setConfirmTime(new Date());
		t.setConfirmBillName(loginUser.getNickName());
		t.setSupplierSapCode(company.getCompanySapCode());
		t.setSupCompanyId(company.getCompanyCode());
		t.setSupplierName(company.getCompanyName());
		t.setChangType(ChangType.QUALIFICATION.getCode());
		t.setUpdateTime(new Date());
		t.setCreateBillTime(new Date());
		if (t.getSupAuthenticationList() !=null && !t.getSupAuthenticationList().isEmpty()) {
			List<SupAuthentication> list = t.getSupAuthenticationList();
			for (int i = 0; i < list.size(); i++) {
				SupAuthentication supAuthentication = list.get(i);
				Assert.isNotNull(supAuthentication.getEffectiveDate(), "证书有效期不能为空");
				if(StringUtils.isBlank(supAuthentication.getAttachment()) || 
						supAuthentication.getAttachment().equals("[]")){
					throw new CommonException("附件不能为空，必须上传附件");
				}
				supAuthentication.setChangbillno(ChangeBillNos);
				supAuthentication.setIsEnable(Constant.YES_INT);
				supAuthentication.setUpdateDate(new Date());
			}
			this.supAuthenticationService.addAll(list);
			this.supplierChangeSheetMapper.insertSelective(t);
		}
	}
	
	@Transactional
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void addPatentsAndAgent(SupplierChangeSheet t, User loginUser, Company company) {
		Assert.isNotEmpty(t.getChangePatentsAndAgentList(), "需要变更的内容不能为空");
		String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
		t.setChangeBillNo(ChangeBillNos);
		t.setConfirmTime(new Date());
		t.setConfirmBillName(loginUser.getNickName());
		t.setSupplierSapCode(company.getCompanySapCode());
		t.setSupCompanyId(company.getCompanyCode());
		t.setSupplierName(company.getCompanyName());
		t.setUpdateTime(new Date());
		t.setCreateBillTime(new Date());
		
		if (t.getChangType() == ChangType.PATENTS.getCode() ) {
			t.getChangePatentsAndAgentList().forEach(patents ->{
				Assert.isNotNull(patents.getEndTime(), "专利/许可的有效期至不能为空");
				if (StringUtils.isBlank(patents.getPatentFile()) || 
						"[]".equals(patents.getPatentFile())) {
					throw new CommonException("专利/许可附件不能为空");
				}
				patents.setChangeBillNo(ChangeBillNos);
				patents.setIsEnable(Constant.YES_INT);
				patents.setCreateTime(new Date());
			});
		}
		if (t.getChangType() == ChangType.AGENT.getCode()) {
			t.getChangePatentsAndAgentList().forEach(agent ->{
				Assert.isNotNull(agent.getAgentTime(), "代理证有效期不能为空");
				Assert.isNotNull(agent.getQualityCertificateTime(), "生产商质量体系证书有效期不能为空");
				agent.setChangeBillNo(ChangeBillNos);
				agent.setIsEnable(Constant.YES_INT);
				agent.setCreateTime(new Date());
			});
		}
		this.supplierChangeSheetMapper.insertSelective(t);
		this.changePatentsAndAgentService.addAll(t.getChangePatentsAndAgentList());
	}
	
	
	@Transactional
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		SupplierChangeSheet sc=	this.supplierChangeSheetMapper.selectByPrimaryKey(id);
		if (sc.getApproveStatus() != ApproveStatus.UNAUDITED.getCode()) {
			throw new CommonException("只有新建的单据才可以删除");
		}
		String changeBillNo = sc.getChangeBillNo();
		// 删除供应商基础变更信息
		SupplierChangeSheetDETAILEExample sheetExample = new SupplierChangeSheetDETAILEExample();
		sheetExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
		this.SupplierChangeSheetDetaleService.deleteByExample(sheetExample);
		// 删除资质变更信息
		SupAuthenticationExample authExample = new SupAuthenticationExample();
		authExample.createCriteria().andChangbillnoEqualTo(changeBillNo);
		this.supAuthenticationService.deleteByExample(authExample);
		// 删除专利/许可和代理数据变更信息
		ChangePatentsAndAgentExample agentExample = new ChangePatentsAndAgentExample();
		agentExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
		this.changePatentsAndAgentService.deleteByExample(agentExample);
		// 删除变更单头部信息
		this.supplierChangeSheetMapper.deleteByPrimaryKey(id);
	}
	
	@Transactional
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void modifyObj(SupplierChangeSheet t) {
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		String changeBillNo = t.getChangeBillNo();
		// 供应商基础信息变更
		if (CollectionUtils.isNotEmpty(t.getSupplierChangeSheetDetaileList())) {
			// 先删除原来的资质数据
			this.SupplierChangeSheetDetaleService.deleteByChangeBillNo(changeBillNo);
			List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
			for (SupplierChangeSheetDETAILE sc : list) {
				sc.setChangeBillNo(changeBillNo);
				sc.setCreateTime(new Date());
				String content = sc.getContent();
				String changeContent = sc.getChangeContent();
				if (content.equals(changeContent)) {
					throw new CommonException("原内容与更改内容不能相同");
				}
				this.SupplierChangeSheetDetaleService.addObj(sc);

			}
			// this.SupplierChangeSheetDetaleService.addAll(list);
		}
		// 供应商资质信息变更
		if (CollectionUtils.isNotEmpty(t.getSupAuthenticationList())) {
			// 先删除原来的资质数据
			this.supAuthenticationService.deleteByChangeBillNo(changeBillNo);

			List<SupAuthentication> supAuthenticationList = t.getSupAuthenticationList();
			for (SupAuthentication supAuthentication : supAuthenticationList) {
				Assert.isNotNull(supAuthentication.getEffectiveDate(), "证书有效期不能为空");
				if (supAuthentication.getAttachment().equals("[]") || 
						StringUtils.isBlank(supAuthentication.getAttachment())) {
					throw new CommonException("证书的附件不能为空，请上传附件");
				}
				supAuthentication.setChangbillno(changeBillNo);
				supAuthentication.setIsEnable(Constant.YES_INT);
				supAuthentication.setUpdateDate(new Date());
				this.supAuthenticationService.addObj(supAuthentication);
			}
			// t.setSupAuthenticationList(supAuthenticationList);
			// this.supAuthenticationService.addAll(supAuthenticationList);
		}
		// 供应商专利/许可和代理数据变更
		if (CollectionUtils.isNotEmpty(t.getChangePatentsAndAgentList())) {
			// 删除原来数据
			ChangePatentsAndAgentExample changeExample = new ChangePatentsAndAgentExample();
			changeExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
			changePatentsAndAgentService.deleteByExample(changeExample);
			// 重新插入数据
			t.getChangePatentsAndAgentList().forEach(change ->{
				if (t.getChangType() == ChangType.PATENTS.getCode()) {
					Assert.isNotNull(change.getEndTime(), "专利/许可的有效期不能为空");
					if (change.getPatentFile().equals("[]") || 
							StringUtils.isBlank(change.getPatentFile())) {
						throw new CommonException("专利/许可的附件不能为空，请上传附件");
					}
				}
				if (t.getChangType() == ChangType.AGENT.getCode()) {
					Assert.isNotNull(change.getAgentTime(), "代理证的有效期不能为空");
					Assert.isNotNull(change.getQualityCertificateTime(), "生产商质量体系证书有效期不能为空");
				}
				change.setChangeBillNo(changeBillNo);
				change.setIsEnable(Constant.YES_INT);
				change.setCreateTime(new Date());
				this.changePatentsAndAgentService.addObj(change);
			});
		}
		t.setUpdateTime(new Date());
		this.supplierChangeSheetMapper.updateByPrimaryKeySelective(t);
	}
	
	@Cacheable(value = "supplierChangeSheet", keyGenerator = "redisKeyGenerator")
	@Override
	public SupplierChangeSheet queryObjById(String id) {
		SupplierChangeSheet sc = this.supplierChangeSheetMapper.selectByPrimaryKey(id);
		Assert.isNotNull(sc, "数据不存在");
		// 供应商基础变更信息
		sc.setSupplierChangeSheetDetaileList(SupplierChangeSheetDetaleService.selectBill(sc.getChangeBillNo()));
		// 供应商资质变更信息
		List<SupAuthentication> selectBill = supAuthenticationService.selectBill(sc.getChangeBillNo());
		sc.setSupAuthenticationList(selectBill);
		// 供应商专利/许可和代理数据变更信息
		ChangePatentsAndAgentExample agentExample = new ChangePatentsAndAgentExample();
		agentExample.createCriteria().andChangeBillNoEqualTo(sc.getChangeBillNo());
		List<ChangePatentsAndAgent> agentList = this.changePatentsAndAgentService.queryAllObjByExample(agentExample);
		sc.setChangePatentsAndAgentList(agentList);
		return sc;
		
	}
	
	@Cacheable(value = "supplierChangeSheet", keyGenerator = "redisKeyGenerator")
	@Override
	public List<SupplierChangeSheet> queryAllObjByExample(SupplierChangeSheetExample example) {
		return this.supplierChangeSheetMapper.selectByExample(example);
	}
	
	@Cacheable(value = "supplierChangeSheet", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<SupplierChangeSheet> queryObjByPage(SupplierChangeSheetExample example) {
		PageView<SupplierChangeSheet> pageView = example.getPageView();
		pageView.setQueryResult(this.supplierChangeSheetMapper.selectByExampleByPage(example));
		return pageView;
	}
	
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void approve(String id) {
		Assert.isNotBlank(id, "模版数据id不能为空");
		SupplierChangeSheet supplierChangeSheet = queryObjById(id);
		if (supplierChangeSheet.getApproveStatus() == ApproveStatus.TOAUDIT.getCode() || 
				supplierChangeSheet.getApproveStatus() == ApproveStatus.AUDITED.getCode()) {
			throw new CommonException("此单据已正在审批或已审批通过，不能再执行送审操作");
		}
		// List<SupplierChangeSheetDETAILE> supplierChangeSheetDetaileList =
		// supplierChangeSheet.getSupplierChangeSheetDetaileList();
		ProcessStartVO vo = ProcessStartVO.newInstance("cgb", supplierChangeSheet.getChangeBillNo(),
				supplierChangeSheet.getId(), "informationChangeRequest?id=" + supplierChangeSheet.getId());
		vo.setListenerClass(this.getClass());
		ProcessInstance startProcess = this.workFlowService.startProcess(vo);
		if (startProcess != null) {
			// 将状态改成审批中
			supplierChangeSheet.setUpdateTime(new Date());
			supplierChangeSheet.setApproveStatus(ApproveStatus.TOAUDIT.getCode());
			supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
		}
	}
	
	@CacheEvict(value = { "supplierChangeSheet" }, allEntries = true)
	@Override
	public void listen(TaskOperateEvent event) {
		if(event==null){
	        logger.info("监听任务为空-----");
			return;
		}
		// 获取业务ID
		String businessId = event.getBusinessId();
		logger.info("获取业务ID-----");
		if (StringUtils.isBlank(businessId)) {
			logger.info("获取业务ID为空-----");
			return;
		}
		// SupplierChangeSheet supplierChangeSheet =
		// this.supplierChangeSheetMapper.selectByPrimaryKey(businessId);
		SupplierChangeSheet supplierChangeSheet = queryObjById(businessId);
		String assignee = StringUtils.defaultIfBlank(event.getAssignee(), "");
		String fullMessage = StringUtils.defaultIfBlank(event.getApproveDesc(), "");
		String result = "审批人：" + assignee + "，审批意见：" + fullMessage + " ; ";
		logger.info("设置审批人和审批意见-----");
		// 1、审批流完成而且通过
		if (event.isFinished() && event.isPass()) {
			logger.info("进入到审批流完成而且通过-----");
			// 做修改业务操作
			supplierChangeSheet.setUpdateTime(new Date());
			supplierChangeSheet.setApproveStatus(ApproveStatus.AUDITED.getCode());
			supplierChangeSheet.setApproveResult(result);
			supplierChangeSheet.setApproveTime(new Date());
			supplierChangeSheet.setApproveUserName(event.getAssignee());
			logger.info("设置审批状态和审批结果完成-----");
			this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
			logger.info("跟新变更单-----");
			// 2、审批流完成但未通过
		} else if (event.isFinished() && !event.isPass()) {
			logger.info("进入到审批流完成但未通过-----");
			supplierChangeSheet.setUpdateTime(new Date());
			supplierChangeSheet.setApproveStatus(ApproveStatus.REFUSED.getCode());
			supplierChangeSheet.setApproveResult(result);
			supplierChangeSheet.setApproveTime(new Date());
			supplierChangeSheet.setApproveUserName(event.getAssignee());
			logger.info("设置审批状态和审批结果完成-----");
			this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
			logger.info("跟新变更单-----");
		}
	}

}