package com.els.base.certification.supplierchangesheet.web.controller;

import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgent;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgentExample;
import com.els.base.certification.supplierchangesheet.service.ChangePatentsAndAgentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商信息变更-专利/许可与代理数据")
@Controller
@RequestMapping("changePatentsAndAgent")
public class ChangePatentsAndAgentController {
    @Resource
    protected ChangePatentsAndAgentService changePatentsAndAgentService;

    @ApiOperation(httpMethod="POST", value="创建供应商信息变更-专利/许可与代理数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ChangePatentsAndAgent changePatentsAndAgent) {
        this.changePatentsAndAgentService.addObj(changePatentsAndAgent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商信息变更-专利/许可与代理数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ChangePatentsAndAgent changePatentsAndAgent) {
        Assert.isNotBlank(changePatentsAndAgent.getId(), "id 为空，保存失败");
        this.changePatentsAndAgentService.modifyObj(changePatentsAndAgent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商信息变更-专利/许可与代理数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        ChangePatentsAndAgentExample example = new ChangePatentsAndAgentExample();
        example.createCriteria().andIdIn(ids);
        this.changePatentsAndAgentService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商信息变更-专利/许可与代理数据")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ChangePatentsAndAgent", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ChangePatentsAndAgent>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ChangePatentsAndAgentExample example = new ChangePatentsAndAgentExample();
        example.setPageView(new PageView<ChangePatentsAndAgent>(pageNo, pageSize));
        
        ChangePatentsAndAgentExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<ChangePatentsAndAgent> pageData = this.changePatentsAndAgentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}