package com.els.base.certification.supplierchangesheet.web.controller;

import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILE;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILEExample;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;


import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="T_BASE_COMPANY_CHANGE_DETAILE")
@Controller
@RequestMapping("supplierChangeSheetDETAILE")
public class SupplierChangeSheetDETAILEController {
    @Resource
    protected SupplierChangeSheetDETAILEService supplierChangeSheetDETAILEService;

    @ApiOperation(httpMethod="POST", value="创建T_BASE_COMPANY_CHANGE_DETAILE")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupplierChangeSheetDETAILE supplierChangeSheetDETAILE) {
        this.supplierChangeSheetDETAILEService.addObj(supplierChangeSheetDETAILE);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑T_BASE_COMPANY_CHANGE_DETAILE")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupplierChangeSheetDETAILE supplierChangeSheetDETAILE) {
        Assert.isNotBlank(supplierChangeSheetDETAILE.getId(), "id 为空，保存失败");
        this.supplierChangeSheetDETAILEService.modifyObj(supplierChangeSheetDETAILE);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除T_BASE_COMPANY_CHANGE_DETAILE")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.supplierChangeSheetDETAILEService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询T_BASE_COMPANY_CHANGE_DETAILE")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 SupplierChangeSheetDETAILE", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierChangeSheetDETAILE>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        SupplierChangeSheetDETAILEExample example = new SupplierChangeSheetDETAILEExample();
        example.setPageView(new PageView<SupplierChangeSheetDETAILE>(pageNo, pageSize));
        
        SupplierChangeSheetDETAILEExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<SupplierChangeSheetDETAILE> pageData = this.supplierChangeSheetDETAILEService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
   
    
    
 
    
}