package com.els.base.certification.technology.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="供应商准入-主要技术")
public class CompanyTechnology  extends AbstractCompany implements Serializable {
	//非自动生成
    //忽略校验的字段
	@Override
	 protected List<String> exculdeFieldNames() {
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("projectId");
        filedNameList.add("purCompanyId");
        filedNameList.add("purCompanySrmCode");
        filedNameList.add("purCompanyName");
        filedNameList.add("supCompanyId");
        filedNameList.add("supCompanySrmCode");
        filedNameList.add("supCompanyName");
        filedNameList.add("isEnable");
        filedNameList.add("createTime");
        filedNameList.add("updateTime");
        filedNameList.add("finishFlag");
        
        return filedNameList;
	}
	
	@ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商名称")
    private String purCompanyName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("关键技术")
    private String pivotalTechnology;

    @ApiModelProperty("核心技术")
    private String centralTechnology;

    @ApiModelProperty("研发工程师数量")
    private Integer engineerQuantity;

    @ApiModelProperty("主要生产技术")
    private String majorProductiveTechnology;

    @ApiModelProperty("主要开发软件")
    private String majorDevelopSoftware;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getPivotalTechnology() {
        return pivotalTechnology;
    }

    public void setPivotalTechnology(String pivotalTechnology) {
        this.pivotalTechnology = pivotalTechnology == null ? null : pivotalTechnology.trim();
    }

    public String getCentralTechnology() {
        return centralTechnology;
    }

    public void setCentralTechnology(String centralTechnology) {
        this.centralTechnology = centralTechnology == null ? null : centralTechnology.trim();
    }

    public Integer getEngineerQuantity() {
        return engineerQuantity;
    }

    public void setEngineerQuantity(Integer engineerQuantity) {
        this.engineerQuantity = engineerQuantity;
    }

    public String getMajorProductiveTechnology() {
        return majorProductiveTechnology;
    }

    public void setMajorProductiveTechnology(String majorProductiveTechnology) {
        this.majorProductiveTechnology = majorProductiveTechnology == null ? null : majorProductiveTechnology.trim();
    }

    public String getMajorDevelopSoftware() {
        return majorDevelopSoftware;
    }

    public void setMajorDevelopSoftware(String majorDevelopSoftware) {
        this.majorDevelopSoftware = majorDevelopSoftware == null ? null : majorDevelopSoftware.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

  /*  public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}