package com.els.base.certification.technology.service;

import java.util.List;

import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface CompanyTechnologyService extends BaseService<CompanyTechnology, CompanyTechnologyExample, String> {
	/**
	 * 批量插入数据
     * @param projectId
     * @param supCompany
     * @param purCompany
     * @param technologyList
     */
	Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyTechnology> technologyList);

	/**
	 * 删除数据
	 * @param projectId
	 * @param company
	 * @param ids
	 */
	void deleteObjByIds(String projectId, Company company, List<String> ids);

	/**
	 * 判断是否填完数据
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
}