package com.els.base.certification.technology.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import com.els.base.core.entity.project.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.els.base.certification.technology.dao.CompanyTechnologyMapper;
import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;

@Service("defaultCompanyTechnologyService")
public class CompanyTechnologyServiceImpl implements CompanyTechnologyService {
    @Resource
    protected CompanyTechnologyMapper companyTechnologyMapper;

    @Cacheable(value="companyTechnology", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {

        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyTechnologyExample companySupplyRelationExample =new CompanyTechnologyExample();
        //如果数据为空，那么返回0
        companySupplyRelationExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyTechnologyMapper.countByExample(companySupplyRelationExample);
        if(count<=0){
            return 0;
        }

        companySupplyRelationExample.clear();
        companySupplyRelationExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyTechnologyMapper.countByExample(companySupplyRelationExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    @Override
    public void addObj(CompanyTechnology t) {
        this.companyTechnologyMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyTechnologyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    @Override
    public void modifyObj(CompanyTechnology t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyTechnologyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyTechnology", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyTechnology queryObjById(String id) {
        return this.companyTechnologyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyTechnology", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyTechnology> queryAllObjByExample(CompanyTechnologyExample example) {
        return this.companyTechnologyMapper.selectByExample(example);
    }

    @Cacheable(value="companyTechnology", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyTechnology> queryObjByPage(CompanyTechnologyExample example) {
        PageView<CompanyTechnology> pageView = example.getPageView();
        pageView.setQueryResult(this.companyTechnologyMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
	@Override
	public Integer batchInsert(String projectId, Company supCompany, Company purCompany,
                               List<CompanyTechnology> technologyList) {
    	if(CollectionUtils.isEmpty(technologyList)){
			throw new CommonException("操作失败，数据不能为空!");
		}
    	
    	CompanyTechnologyExample example = new CompanyTechnologyExample();
    	example.createCriteria()
    		   .andProjectIdEqualTo(projectId)
		       .andSupCompanyIdEqualTo(supCompany.getId())
		       .andIsEnableEqualTo(Constant.YES_INT);
    	
    	CompanyTechnology technology = new CompanyTechnology();
    	technology.setIsEnable(Constant.NO_INT);
    	
    	this.companyTechnologyMapper.updateByExampleSelective(technology, example);
        List<Integer> list = new ArrayList<Integer>();
    	for (CompanyTechnology companyTechnology : technologyList) {
    		companyTechnology.setId(null);
			companyTechnology.setProjectId(projectId);
			companyTechnology.setPurCompanyId(purCompany.getId());
			companyTechnology.setPurCompanySrmCode(purCompany.getCompanyCode());
			companyTechnology.setPurCompanyName(purCompany.getCompanyName());
			companyTechnology.setSupCompanyId(supCompany.getId());
			companyTechnology.setSupCompanySrmCode(supCompany.getCompanyCode());
			companyTechnology.setSupCompanyName(supCompany.getCompanyName());
			companyTechnology.setIsEnable(Constant.YES_INT);
			companyTechnology.setCreateTime(new Date());
			companyTechnology.setUpdateTime(new Date());
			companyTechnology.setFinishFlag(Constant.NO_INT);
			//完成标识,一开始默认是0,0也是非空,不会影响非空判断
			Integer finishFlag = companyTechnology.getFinishFlag();
			companyTechnology.setFinishFlag(finishFlag);
			this.addObj(companyTechnology);

            list.add(finishFlag);

        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }
    
    @Transactional
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
	@Override
	public void deleteObjByIds(String projectId, Company company, List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
        	throw new CommonException("传递的id列表为空!");
        }
    	CompanyTechnologyExample example = new CompanyTechnologyExample();
    	example.createCriteria()
		   .andProjectIdEqualTo(projectId)
		   .andSupCompanyIdEqualTo(company.getId())
		   .andIdIn(ids);
    	
    	CompanyTechnology technology = new CompanyTechnology();
    	technology.setIsEnable(Constant.NO_INT);
    	
    	this.companyTechnologyMapper.updateByExampleSelective(technology, example);
	}
}