
CREATE TABLE "T_BASE_COMPANY_AUDIT_NOTICE" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_CONTACTS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_DESC" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,


  "AUDIT_NOTICE_NO" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "AUDIT_TIME" DATE NULL ,
  "AUDIT_STATUS" NUMBER(7) DEFAULT 0  NULL ,
  "CREATE_BILL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "COMPANY_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "AUDIT_INFO" VARCHAR2(2048 BYTE) NULL ,
  "AUDIT_INFO_FILE" VARCHAR2(2048 BYTE) NULL ,
  "BILL_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "CONFIRM_STATUS" NUMBER(7) DEFAULT 1  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL,
  "SEND_STATUS" NUMBER(7) DEFAULT 0  NULL
);


COMMENT ON TABLE "T_BASE_COMPANY_AUDIT_NOTICE" IS '供应商准入-审核通知单';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PUR_COMPANY_ID" IS '采购公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';

COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_CONTACTS" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_COMPANY_ADDRESS" IS '供应商地址';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_MATERIAL_CODE" IS '供应商物料编码';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SUP_MATERIAL_DESC" IS '供应商物料描述';

COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."AUDIT_NOTICE_NO" IS '审核通知单单号';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."AUDIT_TIME" IS '审核时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."AUDIT_STATUS" IS '审核状态(0=未审核，1=待审核，2已审核)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."CREATE_BILL_NAME" IS '制单人';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."COMPANY_TYPE" IS '供应商类型';

COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."AUDIT_INFO" IS '用于存储审核部门信息';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."AUDIT_INFO_FILE" IS '用于存储审核部门下的文件信息';

COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."BILL_TYPE" IS '单据类型';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."CONFIRM_STATUS" IS '单据状态';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUDIT_NOTICE"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';

ALTER TABLE "T_BASE_COMPANY_AUDIT_NOTICE" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_AUDIT_NOTICE" ADD PRIMARY KEY ("ID");
