
CREATE TABLE "T_BASE_COMPANY_RECOMMEND_FORM" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_PRODUCTION_ADDRESS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_CONTACTS" VARCHAR2(2048 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_INTRODUCTION" VARCHAR2(2048 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_DESC" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "RECOMMENDED_REASON_CODE" VARCHAR2(2048 BYTE) DEFAULT ''  NULL ,
  "RECOMMENDED_REASON_DESC" VARCHAR2(2048 BYTE) DEFAULT ''  NULL ,
  "DEMAND_SOURCES" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "RECOMMEND_NO" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,

  "CREATE_BILL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "CONFIRM_STATUS" NUMBER(7) DEFAULT 1  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL,
  "SEND_STATUS" NUMBER(7) DEFAULT 0  NULL,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL,

  "APPROVE_TIME" DATE NULL ,
  "APPROVE_RESULT" VARCHAR2(2048 BYTE) DEFAULT ''  NULL ,
  "APPROVE_USER_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "APPROVE_STATUS" NUMBER(7) DEFAULT 0  NULL
);


COMMENT ON TABLE "T_BASE_COMPANY_RECOMMEND_FORM" IS '供应商准入-合格供应商导入推荐表';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PUR_COMPANY_ID" IS '采购公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_CONTACTS" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_ADDRESS" IS '供应商地址';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_PRODUCTION_ADDRESS" IS '供应商生产地址';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_CONTACTS" IS '供应商主要联系人';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_TYPE" IS '供应商类型';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_COMPANY_INTRODUCTION" IS '供应商简介';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_MATERIAL_CODE" IS '供应商物料编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SUP_MATERIAL_DESC" IS '供应商物料描述';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."RECOMMENDED_REASON_CODE" IS '推荐理由编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."RECOMMENDED_REASON_DESC" IS '推荐理由编码';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."DEMAND_SOURCES" IS '需求来源';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."RECOMMEND_NO" IS '合格供应商导入推荐表单号';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."CREATE_BILL_NAME" IS '制单人';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."APPROVE_TIME" IS '审核时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."APPROVE_STATUS" IS '审核状态(0=未审核，1=待审核，2已审核)';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."APPROVE_USER_NAME" IS '审核人';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."APPROVE_RESULT" IS '审核结果';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."CONFIRM_STATUS" IS '单据状态';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';

COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RECOMMEND_FORM"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';

ALTER TABLE "T_BASE_COMPANY_RECOMMEND_FORM" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_RECOMMEND_FORM" ADD PRIMARY KEY ("ID");
